/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildNumber
implements Comparable<BuildNumber> {
    private static final Set<String> BUILD_NUMBER_PLACEHOLDERS = ContainerUtil.set((Object[])new String[]{"__BUILD_NUMBER__", "__BUILD__"});
    private static final String STAR = "*";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String FALLBACK_VERSION = "999.SNAPSHOT";
    public static final int SNAPSHOT_VALUE = Integer.MAX_VALUE;
    @NotNull
    private final String myProductCode;
    @NotNull
    private final int[] myComponents;

    public BuildNumber(@NotNull String productCode, int baselineVersion, int buildNumber) {
        this(productCode, new int[]{baselineVersion, buildNumber});
    }

    public BuildNumber(@NotNull String productCode, int ... components) {
        this.myProductCode = productCode;
        this.myComponents = components;
    }

    @NotNull
    public String getProductCode() {
        return this.myProductCode;
    }

    public int getBaselineVersion() {
        return this.myComponents[0];
    }

    @NotNull
    public int[] getComponents() {
        return (int[])this.myComponents.clone();
    }

    public boolean isSnapshot() {
        return ArrayUtil.indexOf((int[])this.myComponents, (int)Integer.MAX_VALUE) >= 0;
    }

    @NotNull
    @Contract(pure=true)
    public BuildNumber withoutProductCode() {
        return this.myProductCode.isEmpty() ? this : new BuildNumber("", this.myComponents);
    }

    @NotNull
    public String asString() {
        return this.asString(true, true);
    }

    @NotNull
    public String asStringWithoutProductCode() {
        return this.asString(false, true);
    }

    @NotNull
    public String asStringWithoutProductCodeAndSnapshot() {
        return this.asString(false, false);
    }

    @NotNull
    private String asString(boolean includeProductCode, boolean withSnapshotMarker) {
        StringBuilder builder = new StringBuilder();
        if (includeProductCode && !StringUtil.isEmpty((String)this.myProductCode)) {
            builder.append(this.myProductCode).append('-');
        }
        for (int each : this.myComponents) {
            if (each != Integer.MAX_VALUE) {
                builder.append(each);
            } else if (withSnapshotMarker) {
                builder.append(SNAPSHOT);
            }
            builder.append('.');
        }
        if (builder.charAt(builder.length() - 1) == '.') {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    @Nullable
    public static BuildNumber fromStringOrNull(@NotNull String version) {
        try {
            return BuildNumber.fromString(version);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    public static BuildNumber fromString(String version) {
        return BuildNumber.fromString(version, null, null);
    }

    public static BuildNumber fromStringWithProductCode(String version, @NotNull String productCode) {
        return BuildNumber.fromString(version, null, productCode);
    }

    public static BuildNumber fromString(String version, @Nullable String pluginName, @Nullable String productCodeIfAbsentInVersion) {
        String productCode;
        if (StringUtil.isEmptyOrSpaces((String)version)) {
            return null;
        }
        String code = version;
        int productSeparator = code.indexOf(45);
        if (productSeparator > 0) {
            productCode = code.substring(0, productSeparator);
            code = code.substring(productSeparator + 1);
        } else {
            String string = productCode = productCodeIfAbsentInVersion != null ? productCodeIfAbsentInVersion : "";
        }
        if (BUILD_NUMBER_PLACEHOLDERS.contains(code) || SNAPSHOT.equals(code)) {
            return new BuildNumber(productCode, BuildNumber.currentVersion().myComponents);
        }
        int baselineVersionSeparator = code.indexOf(46);
        if (baselineVersionSeparator > 0) {
            String baselineVersionString = code.substring(0, baselineVersionSeparator);
            if (baselineVersionString.trim().isEmpty()) {
                return null;
            }
            List stringComponents = StringUtil.split((String)code, (String)".");
            TIntArrayList intComponentsList = new TIntArrayList();
            for (String stringComponent : stringComponents) {
                int comp = BuildNumber.parseBuildNumber(version, stringComponent, pluginName);
                intComponentsList.add(comp);
                if (comp != Integer.MAX_VALUE) continue;
                break;
            }
            int[] intComponents = intComponentsList.toNativeArray();
            return new BuildNumber(productCode, intComponents);
        }
        int buildNumber = BuildNumber.parseBuildNumber(version, code, pluginName);
        if (buildNumber <= 2000) {
            return new BuildNumber(productCode, buildNumber, 0);
        }
        int baselineVersion = BuildNumber.getBaseLineForHistoricBuilds(buildNumber);
        return new BuildNumber(productCode, baselineVersion, buildNumber);
    }

    private static int parseBuildNumber(String version, @NotNull String code, String pluginName) {
        if (SNAPSHOT.equals(code) || BUILD_NUMBER_PLACEHOLDERS.contains(code) || STAR.equals(code)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid version number: " + version + "; plugin name: " + pluginName);
        }
    }

    @Override
    public int compareTo(@NotNull BuildNumber o) {
        int[] c1 = this.myComponents;
        int[] c2 = o.myComponents;
        for (int i = 0; i < Math.min(c1.length, c2.length); ++i) {
            if (c1[i] == c2[i] && c1[i] == Integer.MAX_VALUE) {
                return 0;
            }
            if (c1[i] == Integer.MAX_VALUE) {
                return 1;
            }
            if (c2[i] == Integer.MAX_VALUE) {
                return -1;
            }
            int result2 = c1[i] - c2[i];
            if (result2 == 0) continue;
            return result2;
        }
        return c1.length - c2.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildNumber that = (BuildNumber)o;
        if (!this.myProductCode.equals(that.myProductCode)) {
            return false;
        }
        return Arrays.equals(this.myComponents, that.myComponents);
    }

    public int hashCode() {
        int result2 = this.myProductCode.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.myComponents);
        return result2;
    }

    public String toString() {
        return this.asString();
    }

    private static int getBaseLineForHistoricBuilds(int bn) {
        if (bn >= 10000) {
            return 88;
        }
        if (bn >= 9500) {
            return 85;
        }
        if (bn >= 9100) {
            return 81;
        }
        if (bn >= 8000) {
            return 80;
        }
        if (bn >= 7500) {
            return 75;
        }
        if (bn >= 7200) {
            return 72;
        }
        if (bn >= 6900) {
            return 69;
        }
        if (bn >= 6500) {
            return 65;
        }
        if (bn >= 6000) {
            return 60;
        }
        if (bn >= 5000) {
            return 55;
        }
        if (bn >= 4000) {
            return 50;
        }
        return 40;
    }

    public static BuildNumber currentVersion() {
        return Holder.CURRENT_VERSION;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019")
    public int getBuildNumber() {
        return this.myComponents[1];
    }

    private static class Holder {
        private static final BuildNumber CURRENT_VERSION = Holder.fromFile();

        private Holder() {
        }

        private static BuildNumber fromFile() {
            try {
                String home = PathManager.getHomePath();
                File buildTxtFile = FileUtil.findFirstThatExist((String[])new String[]{home + "/build.txt", home + "/Resources/build.txt", PathManager.getCommunityHomePath() + "/build.txt"});
                if (buildTxtFile != null) {
                    String text = FileUtil.loadFile((File)buildTxtFile).trim();
                    return BuildNumber.fromString(text);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return BuildNumber.fromString(BuildNumber.FALLBACK_VERSION);
        }
    }
}

