/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyedExtensionCollector<T, KeyT>
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.KeyedExtensionCollector");
    private final Map<String, List<T>> myExplicitExtensions = new THashMap();
    private final ConcurrentMap<String, List<T>> myCache = ContainerUtil.newConcurrentMap();
    @NonNls
    protected final String lock;
    private final String myEpName;
    private final SimpleModificationTracker myTracker = new SimpleModificationTracker();
    private final ExtensionPointAndAreaListener<KeyedLazyInstance<T>> myListener = new ExtensionPointAndAreaListener<KeyedLazyInstance<T>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void extensionAdded(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
            String string = KeyedExtensionCollector.this.lock;
            synchronized (string) {
                if (bean.getKey() == null) {
                    if (pluginDescriptor != null) {
                        throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
                    }
                    LOG.error("No key specified for extension of class " + bean.getInstance().getClass());
                    return;
                }
                KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                KeyedExtensionCollector.this.myTracker.incModificationCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void extensionRemoved(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
            String string = KeyedExtensionCollector.this.lock;
            synchronized (string) {
                KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                KeyedExtensionCollector.this.myTracker.incModificationCount();
            }
        }

        public void areaReplaced(@NotNull ExtensionsArea area) {
            KeyedExtensionCollector.this.myCache.clear();
            KeyedExtensionCollector.this.myTracker.incModificationCount();
        }
    };

    public KeyedExtensionCollector(@NonNls @NotNull String epName) {
        this(epName, null);
    }

    public KeyedExtensionCollector(final @NonNls @NotNull String epName, final @Nullable Disposable parentDisposable) {
        this.myEpName = epName;
        this.lock = "lock for KeyedExtensionCollector " + epName;
        Extensions.getRootArea().addAvailabilityListener(epName, new ExtensionPointAvailabilityListener(){

            public void extensionPointRegistered(@NotNull ExtensionPoint extensionPoint) {
                if (extensionPoint.getName().equals(epName)) {
                    extensionPoint.addExtensionPointListener((ExtensionPointListener)KeyedExtensionCollector.this.myListener, false, parentDisposable);
                    KeyedExtensionCollector.this.myCache.clear();
                    KeyedExtensionCollector.this.myTracker.incModificationCount();
                }
            }

            public void extensionPointRemoved(@NotNull ExtensionPoint extensionPoint) {
            }
        }, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List list = this.myExplicitExtensions.computeIfAbsent(skey, __ -> new SmartList());
            list.add(t);
            this.myCache.remove(skey);
            this.myTracker.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list != null) {
                list.remove(t);
                if (list.isEmpty()) {
                    this.myExplicitExtensions.remove(skey);
                }
            }
            this.myCache.remove(skey);
            this.myTracker.incModificationCount();
        }
    }

    @NotNull
    protected String keyToString(@NotNull KeyT key) {
        return key.toString();
    }

    @NotNull
    public List<T> forKey(@NotNull KeyT key) {
        String stringKey = this.keyToString(key);
        Object cached = (ImmutableList)this.myCache.get(stringKey);
        if (cached == null) {
            List<T> list = this.buildExtensions(stringKey, key);
            cached = list.isEmpty() ? Collections.emptyList() : (list.size() == 1 ? ContainerUtil.immutableSingletonList(list.get(0)) : ContainerUtil.immutableList((Object[])list.toArray()));
            cached = (List)ConcurrencyUtil.cacheOrGet(this.myCache, (Object)stringKey, cached);
        }
        return cached;
    }

    public T findSingle(@NotNull KeyT key) {
        List<T> list = this.forKey(key);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull KeyT key) {
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string = this.lock;
        synchronized (string) {
            List<T> list = this.myExplicitExtensions.get(stringKey);
            return ContainerUtil.notNullize(this.buildExtensionsFromExtensionPoint(list == null ? null : new ArrayList<T>(list), bean -> stringKey.equals(bean.getKey()), extensions));
        }
    }

    @NotNull
    protected final List<KeyedLazyInstance<T>> getExtensions() {
        ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
        return point == null ? Collections.emptyList() : point.getExtensionList();
    }

    protected final List<T> buildExtensionsFromExtensionPoint(@Nullable List<T> result2, @NotNull Predicate<? super KeyedLazyInstance<T>> isMyBean, @NotNull List<KeyedLazyInstance<T>> extensions) {
        for (KeyedLazyInstance<T> bean : extensions) {
            T instance;
            if (!isMyBean.test(bean)) continue;
            try {
                instance = bean.getInstance();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (ExtensionNotApplicableException ignore) {
                continue;
            }
            catch (Exception | LinkageError e) {
                LOG.error(e);
                continue;
            }
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add(instance);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<T> buildExtensions(@NotNull Set<String> keys) {
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string = this.lock;
        synchronized (string) {
            List<T> result2 = this.buildExtensionsFromExplicitRegistration(null, (Condition<String>)((Condition)key -> keys.contains(key)));
            result2 = this.buildExtensionsFromExtensionPoint(result2, bean -> keys.contains(bean.getKey()), extensions);
            return ContainerUtil.notNullize(result2);
        }
    }

    @Nullable
    protected List<T> buildExtensionsFromExplicitRegistration(@Nullable List<T> result2, Condition<String> isMyBean) {
        for (Map.Entry<String, List<T>> entry : this.myExplicitExtensions.entrySet()) {
            String key = entry.getKey();
            if (!isMyBean.value((Object)key)) continue;
            List<T> list = entry.getValue();
            if (result2 == null) {
                result2 = new ArrayList<T>(list);
                continue;
            }
            result2.addAll(list);
        }
        return result2;
    }

    @Nullable
    private ExtensionPoint<KeyedLazyInstance<T>> getPoint() {
        return Extensions.getRootArea().hasExtensionPoint(this.myEpName) ? Extensions.getRootArea().getExtensionPoint(this.myEpName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string = this.lock;
        synchronized (string) {
            if (!this.myExplicitExtensions.isEmpty()) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
            return point != null && point.hasAnyExtensions();
        }
    }

    @NotNull
    public String getName() {
        return this.myEpName;
    }

    @Override
    public long getModificationCount() {
        return this.myTracker.getModificationCount();
    }

    protected void ensureValuesLoaded() {
        ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
        if (point != null) {
            for (KeyedLazyInstance bean : point.getExtensionList()) {
                bean.getInstance();
            }
        }
    }
}

