/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.SimpleTimerTask;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SimpleTimer {
    private static final SimpleTimer ourInstance = SimpleTimer.newInstance("Shared");
    private final ScheduledExecutorService myScheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"SimpleTimer Pool", (int)1);
    @NotNull
    private final String myName;

    private SimpleTimer(@NotNull String name) {
        this.myName = name;
    }

    public static SimpleTimer getInstance() {
        return ourInstance;
    }

    public static SimpleTimer newInstance(@NotNull String name) {
        return new SimpleTimer(name);
    }

    @NotNull
    public SimpleTimerTask setUp(@NotNull Runnable runnable, long delay) {
        final ScheduledFuture<?> future = this.myScheduledExecutorService.schedule(runnable, delay, TimeUnit.MILLISECONDS);
        return new SimpleTimerTask(){

            @Override
            public void cancel() {
                future.cancel(false);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }
        };
    }

    public String toString() {
        return "SimpleTimer " + this.myName;
    }
}

