/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="Registry", storages={@Storage(value="ide.general.xml")})
public class RegistryState
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(RegistryState.class);

    @Override
    public Element getState() {
        return Registry.getInstance().getState();
    }

    @Override
    public void loadState(@NotNull Element state) {
        Registry.getInstance().loadState(state);
        TreeMap userProperties = new TreeMap(Registry.getInstance().getUserProperties());
        userProperties.remove("ide.firstStartup");
        if (!userProperties.isEmpty()) {
            LOG.info("Registry values changed by user:");
            for (Map.Entry entry : userProperties.entrySet()) {
                LOG.info("  " + (String)entry.getKey() + " = " + (String)entry.getValue());
            }
        }
        SmartList enabledIds = new SmartList();
        for (ExperimentalFeature e : Experiments.EP_NAME.getExtensionList()) {
            if (!Experiments.isFeatureEnabled(e.id)) continue;
            enabledIds.add(e.id);
        }
        if (!enabledIds.isEmpty()) {
            LOG.info("Experimental features enabled for user: " + StringUtil.join((Collection)enabledIds, (String)", "));
        }
    }
}

