/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsTaskHandler {
    private static final String DEFAULT_PROHIBITED_SYMBOLS = " ";
    private static final ExtensionPointName<VcsTaskHandler> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.vcs.taskHandler");

    public static VcsTaskHandler[] getAllHandlers(Project project) {
        Object[] extensions = (VcsTaskHandler[])EXTENSION_POINT_NAME.getExtensions((AreaInstance)project);
        List handlers = ContainerUtil.filter((Object[])extensions, handler -> handler.isEnabled());
        return handlers.toArray(new VcsTaskHandler[0]);
    }

    public abstract boolean isEnabled();

    public abstract TaskInfo startNewTask(@NotNull String var1);

    public abstract void switchToTask(TaskInfo var1, @Nullable Runnable var2);

    public abstract void closeTask(@NotNull TaskInfo var1, @NotNull TaskInfo var2);

    public abstract boolean isSyncEnabled();

    @NotNull
    public abstract TaskInfo[] getCurrentTasks();

    public abstract TaskInfo[] getAllExistingTasks();

    public boolean isBranchNameValid(@NotNull String branchName) {
        return !branchName.contains(DEFAULT_PROHIBITED_SYMBOLS);
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String suggestedName) {
        return suggestedName.replaceAll(DEFAULT_PROHIBITED_SYMBOLS, "-");
    }

    public static class TaskInfo
    implements Comparable<TaskInfo> {
        private final String myBranch;
        private final Collection<String> myRepositories;
        private final boolean myRemote;

        public TaskInfo(String branch, Collection<String> repositories) {
            this(branch, repositories, false);
        }

        public TaskInfo(String branch, Collection<String> repositories, boolean remote) {
            this.myBranch = branch;
            this.myRepositories = repositories;
            this.myRemote = remote;
        }

        public String getName() {
            return this.myBranch;
        }

        public boolean isRemote() {
            return this.myRemote;
        }

        public Collection<String> getRepositories() {
            return this.myRepositories;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public int compareTo(TaskInfo o) {
            return Comparing.compare((Comparable)((Object)this.myBranch), (Comparable)((Object)o.myBranch));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskInfo info = (TaskInfo)o;
            if (this.myRemote != info.myRemote) {
                return false;
            }
            if (!this.myBranch.equals(info.myBranch)) {
                return false;
            }
            return this.myRepositories.size() == info.myRepositories.size() && this.myRepositories.containsAll(info.myRepositories);
        }

        public int hashCode() {
            return this.myBranch.hashCode();
        }
    }
}

