/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PlaceProvider;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsContext
extends PlaceProvider<String> {
    @Nullable
    public Project getProject();

    @Nullable
    public VirtualFile getSelectedFile();

    @NotNull
    public VirtualFile[] getSelectedFiles();

    @NotNull
    default public Stream<VirtualFile> getSelectedFilesStream() {
        return Arrays.stream(this.getSelectedFiles());
    }

    @NotNull
    default public List<VirtualFile> getSelectedUnversionedFiles() {
        return Collections.emptyList();
    }

    public Editor getEditor();

    public Collection<VirtualFile> getSelectedFilesCollection();

    public File[] getSelectedIOFiles();

    public int getModifiers();

    public Refreshable getRefreshableDialog();

    public File getSelectedIOFile();

    @NotNull
    public FilePath[] getSelectedFilePaths();

    @NotNull
    default public Stream<FilePath> getSelectedFilePathsStream() {
        return Arrays.stream(this.getSelectedFilePaths());
    }

    @Nullable
    public FilePath getSelectedFilePath();

    @Nullable
    public ChangeList[] getSelectedChangeLists();

    @Nullable
    public Change[] getSelectedChanges();

    public String getActionName();
}

