/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.changes.Change;
import gnu.trove.TObjectHashingStrategy;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ChangeListChange
extends Change {
    @NotNull
    private final Change myChange;
    @NotNull
    private final String myChangeListName;
    private final String myChangeListId;
    public static final TObjectHashingStrategy<Object> HASHING_STRATEGY = new TObjectHashingStrategy<Object>(){

        public int computeHashCode(Object object) {
            return Objects.hashCode(object);
        }

        public boolean equals(Object o1, Object o2) {
            if (o1 instanceof Change && o2 instanceof Change && (o1 instanceof ChangeListChange || o2 instanceof ChangeListChange)) {
                if (o1 instanceof ChangeListChange && o2 instanceof ChangeListChange) {
                    ChangeListChange lc1 = (ChangeListChange)o1;
                    ChangeListChange lc2 = (ChangeListChange)o2;
                    return Objects.equals(o1, o2) && Objects.equals(lc1.getChangeListId(), lc2.getChangeListId());
                }
                return false;
            }
            return Objects.equals(o1, o2);
        }
    };

    public ChangeListChange(@NotNull Change change, @NotNull String changeListName, @NotNull String changeListId) {
        super(change);
        this.myChange = change;
        this.myChangeListName = changeListName;
        this.myChangeListId = changeListId;
    }

    @NotNull
    public Change getChange() {
        return this.myChange;
    }

    @NotNull
    public String getChangeListName() {
        return this.myChangeListName;
    }

    @NotNull
    public String getChangeListId() {
        return this.myChangeListId;
    }
}

