/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentBinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentContentRevision
implements ByteBackedContentRevision {
    protected FilePath myFile;

    public CurrentContentRevision(FilePath file) {
        this.myFile = file;
    }

    @Override
    @Nullable
    public String getContent() {
        VirtualFile vFile = this.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        Document doc = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(vFile));
        if (doc == null) {
            return null;
        }
        return doc.getText();
    }

    @Override
    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        VirtualFile vFile = this.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        try {
            return vFile.contentsToByteArray();
        }
        catch (IOException e) {
            throw new VcsException(e);
        }
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile vFile = this.myFile.getVirtualFile();
        if (vFile == null || !vFile.isValid()) {
            return null;
        }
        return vFile;
    }

    @Override
    @NotNull
    public FilePath getFile() {
        return this.myFile;
    }

    @Override
    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return VcsRevisionNumber.NULL;
    }

    @NotNull
    public static ContentRevision create(@NotNull FilePath file) {
        if (file.getFileType().isBinary()) {
            return new CurrentBinaryContentRevision(file);
        }
        return new CurrentContentRevision(file);
    }

    @NonNls
    public String toString() {
        return "CurrentContentRevision:" + this.myFile;
    }
}

