/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoredBeanFactory {
    private IgnoredBeanFactory() {
    }

    @NotNull
    public static IgnoredFileBean ignoreUnderDirectory(@NotNull @NonNls String path2, @Nullable Project p) {
        String correctedPath = path2.endsWith("/") || path2.endsWith(File.separator) ? path2 : path2 + "/";
        return new IgnoredFileBean(correctedPath, IgnoreSettingsType.UNDER_DIR, p);
    }

    @NotNull
    public static IgnoredFileBean ignoreFile(@NotNull @NonNls String path2, @Nullable Project p) {
        return new IgnoredFileBean(path2, IgnoreSettingsType.FILE, p);
    }

    @NotNull
    public static IgnoredFileBean ignoreFile(@NotNull VirtualFile file, @Nullable Project p) {
        if (file.isDirectory()) {
            return IgnoredBeanFactory.ignoreUnderDirectory(file.getPath(), p);
        }
        return IgnoredBeanFactory.ignoreFile(file.getPath(), p);
    }

    @NotNull
    public static IgnoredFileBean withMask(@NotNull String mask) {
        return new IgnoredFileBean(mask);
    }
}

