/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalChangeList
implements Cloneable,
ChangeList {
    @NonNls
    public static final String DEFAULT_NAME = VcsBundle.message("changes.default.changelist.name", new Object[0]);
    @NonNls
    public static final String OLD_DEFAULT_NAME = "Default";

    public static LocalChangeList createEmptyChangeList(Project project, @NotNull String name) {
        return VcsContextFactory.SERVICE.getInstance().createLocalChangeList(project, name);
    }

    @Override
    public abstract Collection<Change> getChanges();

    @NotNull
    public String getId() {
        return this.getName();
    }

    @Override
    @NotNull
    public abstract String getName();

    @Override
    @Nullable
    public abstract String getComment();

    public abstract boolean isDefault();

    public abstract boolean isReadOnly();

    @Nullable
    public abstract Object getData();

    public abstract LocalChangeList copy();

    public boolean hasDefaultName() {
        return DEFAULT_NAME.equals(this.getName()) || OLD_DEFAULT_NAME.equals(this.getName());
    }

    public boolean isBlank() {
        return this.hasDefaultName() && this.getData() == null;
    }

    @Deprecated
    public abstract void setName(@NotNull String var1);

    @Deprecated
    public abstract void setComment(@Nullable String var1);

    @Deprecated
    public abstract void setReadOnly(boolean var1);
}

