/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import org.jetbrains.annotations.NotNull;

public class TextRevisionNumber
implements ShortVcsRevisionNumber {
    @NotNull
    private final String myFullRevisionNumber;
    @NotNull
    private final String myShortRevisionNumber;

    public TextRevisionNumber(@NotNull String fullRevisionNumber) {
        this(fullRevisionNumber, fullRevisionNumber.substring(0, Math.min(7, fullRevisionNumber.length())));
    }

    public TextRevisionNumber(@NotNull String fullRevisionNumber, @NotNull String shortRevisionNumber) {
        this.myFullRevisionNumber = fullRevisionNumber;
        this.myShortRevisionNumber = shortRevisionNumber;
    }

    @Override
    public String asString() {
        return this.myFullRevisionNumber;
    }

    @Override
    public int compareTo(@NotNull VcsRevisionNumber o) {
        return Comparing.compare((Comparable)((Object)this.myFullRevisionNumber), (Comparable)((Object)((TextRevisionNumber)o).myFullRevisionNumber));
    }

    @Override
    public String toShortString() {
        return this.myShortRevisionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myFullRevisionNumber.equals(((TextRevisionNumber)o).myFullRevisionNumber);
    }

    public int hashCode() {
        return this.myFullRevisionNumber.hashCode();
    }
}

