/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.PeekableIteratorWrapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StepIntersection {
    public static <T, V> void processIntersections(@NotNull List<? extends T> elements1, @NotNull List<? extends V> elements2, @NotNull Convertor<? super T, ? extends TextRange> convertor1, @NotNull Convertor<? super V, ? extends TextRange> convertor2, @NotNull PairConsumer<? super T, ? super V> intersectionConsumer) {
        PeekableIteratorWrapper peekIterator1 = new PeekableIteratorWrapper(elements1.iterator());
        block0: for (V item2 : elements2) {
            TextRange range2 = (TextRange)convertor2.convert(item2);
            while (peekIterator1.hasNext()) {
                Object item1 = peekIterator1.peek();
                TextRange range1 = (TextRange)convertor1.convert(item1);
                if (range1.intersects(range2)) {
                    intersectionConsumer.consume(item1, item2);
                }
                if (range2.getEndOffset() < range1.getEndOffset()) continue block0;
                peekIterator1.next();
            }
            break block0;
        }
    }

    public static <T, V> void processElementIntersections(@NotNull T element1, @NotNull List<? extends V> elements2, @NotNull Convertor<? super T, ? extends TextRange> convertor1, @NotNull Convertor<? super V, ? extends TextRange> convertor2, @NotNull PairConsumer<? super T, ? super V> intersectionConsumer) {
        TextRange range1 = (TextRange)convertor1.convert(element1);
        int index2 = ObjectUtils.binarySearch((int)0, (int)elements2.size(), mid -> {
            Object item2 = elements2.get(mid);
            TextRange range2 = (TextRange)convertor2.convert(item2);
            return Integer.compare(range2.getEndOffset(), range1.getStartOffset());
        });
        if (index2 < 0) {
            index2 = -index2 - 1;
        }
        for (int i = index2; i < elements2.size(); ++i) {
            V item2 = elements2.get(i);
            TextRange range2 = (TextRange)convertor2.convert(item2);
            if (range1.intersects(range2)) {
                intersectionConsumer.consume(element1, item2);
            }
            if (range2.getStartOffset() > range1.getEndOffset()) break;
        }
    }
}

