/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.BaseCheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import org.jetbrains.annotations.NotNull;

public abstract class VcsCheckinHandlerFactory
implements BaseCheckinHandlerFactory {
    public static final ExtensionPointName<VcsCheckinHandlerFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.vcsCheckinHandlerFactory");
    private final VcsKey myKey;

    protected VcsCheckinHandlerFactory(@NotNull VcsKey key) {
        this.myKey = key;
    }

    @Override
    @NotNull
    public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        if (!panel.vcsIsAffected(this.myKey.getName())) {
            return CheckinHandler.DUMMY;
        }
        return this.createVcsHandler(panel);
    }

    @NotNull
    protected abstract CheckinHandler createVcsHandler(CheckinProjectPanel var1);

    public VcsKey getKey() {
        return this.myKey;
    }

    @Override
    public BeforeCheckinDialogHandler createSystemReadyHandler(@NotNull Project project) {
        return null;
    }
}

