/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ReadonlyStatusHandler {
    public static boolean ensureFilesWritable(@NotNull Project project, VirtualFile ... files) {
        return !ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(Arrays.asList(files)).hasReadonlyFiles();
    }

    public static boolean ensureDocumentWritable(@NotNull Project project, @NotNull Document document) {
        VirtualFile virtualFile2;
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document);
        boolean okWritable = psiFile == null ? document.isWritable() : ((virtualFile2 = psiFile.getVirtualFile()) != null ? ReadonlyStatusHandler.ensureFilesWritable(project, virtualFile2) : psiFile.isWritable());
        return okWritable;
    }

    @Deprecated
    @NotNull
    public OperationStatus ensureFilesWritable(VirtualFile ... files) {
        return this.ensureFilesWritable(Arrays.asList(files));
    }

    @NotNull
    public abstract OperationStatus ensureFilesWritable(@NotNull Collection<VirtualFile> var1);

    public static ReadonlyStatusHandler getInstance(@NotNull Project project) {
        return ServiceManager.getService(project, ReadonlyStatusHandler.class);
    }

    public static abstract class OperationStatus {
        @NotNull
        public abstract VirtualFile[] getReadonlyFiles();

        public abstract boolean hasReadonlyFiles();

        @NotNull
        public abstract String getReadonlyFilesMessage();
    }
}

