/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a8\u0006\b"}, d2={"useSafeStream", "", "requestor", "", "file", "Ljava/nio/file/Path;", "safeOutputStream", "Ljava/io/OutputStream;", "intellij.platform.ide"})
@JvmName(name="SafeWriteUtil")
public final class SafeWriteUtil {
    @NotNull
    public static final OutputStream safeOutputStream(@NotNull Path $receiver, @Nullable Object requestor) {
        PathKt.createDirectories($receiver.getParent());
        return SafeWriteUtil.useSafeStream(requestor, $receiver) ? (OutputStream)new SafeFileOutputStream($receiver.toFile()) : Files.newOutputStream($receiver, new OpenOption[0]);
    }

    private static final boolean useSafeStream(Object requestor, Path file) {
        return requestor instanceof SafeWriteRequestor && GeneralSettings.getInstance().isUseSafeWrite() && !Files.isSymbolicLink(file);
    }
}

