/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WritingAccessProvider {
    public static final ExtensionPointName<WritingAccessProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.writingAccessProvider");

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files) {
        return this.requestWriting(files.toArray(VirtualFile.EMPTY_ARRAY));
    }

    @Deprecated
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        throw new AbstractMethodError("requestWriting(List<VirtualFile>) not implemented");
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file) {
        return true;
    }

    @NotNull
    public static WritingAccessProvider[] getProvidersForProject(@Nullable Project project) {
        return project == null || project.isDefault() ? new WritingAccessProvider[]{} : (WritingAccessProvider[])EP_NAME.getExtensions((AreaInstance)project);
    }

    public static boolean isPotentiallyWritable(@NotNull VirtualFile file, @Nullable Project project) {
        WritingAccessProvider[] providers;
        for (WritingAccessProvider provider : providers = WritingAccessProvider.getProvidersForProject(project)) {
            if (provider.isPotentiallyWritable(file)) continue;
            return false;
        }
        return true;
    }
}

