/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.vfs.impl.AddonlyKeylessHash;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.ByteArrayCharSequence;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveHandler {
    public static final long DEFAULT_LENGTH = 0L;
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final File myPath;
    private final Object myLock = new Object();
    private volatile Reference<Map<String, EntryInfo>> myEntries = new SoftReference(null);
    private volatile Reference<AddonlyKeylessHash<EntryInfo, Object>> myChildrenEntries = new SoftReference(null);
    private boolean myCorrupted;
    private static final AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object> ourKeyValueMapper = new AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object>(){

        @Override
        public int hash(EntryInfo info) {
            return System.identityHashCode(info);
        }

        @Override
        public EntryInfo key(Object o) {
            if (o instanceof EntryInfo) {
                return ((EntryInfo)o).parent;
            }
            return ((EntryInfo[])o)[0].parent;
        }
    };

    protected ArchiveHandler(@NotNull String path2) {
        this.myPath = new File(path2);
    }

    @NotNull
    public File getFile() {
        return this.myPath;
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull String relativePath) {
        if (relativePath.isEmpty()) {
            FileAttributes attributes = FileSystemUtil.getAttributes((File)this.myPath);
            return attributes != null ? new FileAttributes(true, false, false, false, 0L, -1L, false) : null;
        }
        EntryInfo entry = this.getEntryInfo(relativePath);
        return entry != null ? new FileAttributes(entry.isDirectory, false, false, false, entry.length, entry.timestamp, false) : null;
    }

    @NotNull
    public String[] list(@NotNull String relativePath) {
        EntryInfo entry = this.getEntryInfo(relativePath);
        if (entry == null || !entry.isDirectory) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        AddonlyKeylessHash<EntryInfo, Object> result2 = this.getParentChildrenMap();
        Object o = result2.get(entry);
        if (o == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (o instanceof EntryInfo) {
            return new String[]{((EntryInfo)o).shortName.toString()};
        }
        EntryInfo[] infos = (EntryInfo[])o;
        String[] names = new String[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            names[i] = infos[i].shortName.toString();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private AddonlyKeylessHash<EntryInfo, Object> getParentChildrenMap() {
        AddonlyKeylessHash<EntryInfo, Object> map = (AddonlyKeylessHash<EntryInfo, Object>)SoftReference.dereference(this.myChildrenEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = (AddonlyKeylessHash)SoftReference.dereference(this.myChildrenEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = new AddonlyKeylessHash<EntryInfo, Object>(ourKeyValueMapper);
                    } else {
                        try {
                            map = this.createParentChildrenMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, (Throwable)e);
                            map = new AddonlyKeylessHash<EntryInfo, Object>(ourKeyValueMapper);
                        }
                    }
                    this.myChildrenEntries = new SoftReference(map);
                }
            }
        }
        return map;
    }

    private AddonlyKeylessHash<EntryInfo, Object> createParentChildrenMap() {
        THashMap map = new THashMap();
        for (EntryInfo info : this.getEntriesMap().values()) {
            if (info.isDirectory && !map.containsKey((Object)info)) {
                map.put((Object)info, (Object)new SmartList());
            }
            if (info.parent == null) continue;
            List parentChildren = (List)map.get((Object)info.parent);
            if (parentChildren == null) {
                parentChildren = new SmartList();
                map.put((Object)info.parent, (Object)parentChildren);
            }
            parentChildren.add(info);
        }
        final AddonlyKeylessHash<EntryInfo, Object> result2 = new AddonlyKeylessHash<EntryInfo, Object>(map.size(), ourKeyValueMapper);
        map.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<EntryInfo, List<EntryInfo>>(){

            public boolean execute(EntryInfo a, List<EntryInfo> b) {
                int numberOfChildren = b.size();
                if (numberOfChildren == 1) {
                    result2.add(b.get(0));
                } else if (numberOfChildren > 1) {
                    result2.add(b.toArray(new EntryInfo[numberOfChildren]));
                }
                return true;
            }
        });
        return result2;
    }

    public void dispose() {
        this.clearCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCaches() {
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.clear();
            this.myChildrenEntries.clear();
            this.myCorrupted = false;
        }
    }

    @Nullable
    protected EntryInfo getEntryInfo(@NotNull String relativePath) {
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<Object, Object> map = (Map)SoftReference.dereference(this.myEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = (Map)SoftReference.dereference(this.myEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = Collections.emptyMap();
                    } else {
                        try {
                            map = this.createEntriesMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, (Throwable)e);
                            map = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new SoftReference(map);
                }
            }
        }
        return map;
    }

    @NotNull
    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    @NotNull
    protected EntryInfo createRootEntry() {
        return new EntryInfo("", true, 0L, -1L, null);
    }

    @NotNull
    protected EntryInfo getOrCreate(@NotNull Map<String, EntryInfo> map, @NotNull String entryName) {
        EntryInfo entry = map.get(entryName);
        if (entry == null) {
            Pair<String, String> path2 = this.splitPath(entryName);
            EntryInfo parentEntry = this.getOrCreate(map, (String)path2.first);
            CharSequence shortName = ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)((CharSequence)path2.second));
            entry = new EntryInfo(shortName, true, 0L, -1L, parentEntry);
            map.put(entryName, entry);
        }
        return entry;
    }

    @NotNull
    protected Pair<String, String> splitPath(@NotNull String entryName) {
        int p = entryName.lastIndexOf(47);
        String parentName = p > 0 ? entryName.substring(0, p) : "";
        String shortName = p > 0 ? entryName.substring(p + 1) : entryName;
        return Pair.create((Object)parentName, (Object)shortName);
    }

    @NotNull
    public abstract byte[] contentsToByteArray(@NotNull String var1) throws IOException;

    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray(relativePath));
    }

    protected static class EntryInfo {
        public final EntryInfo parent;
        public final CharSequence shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        public EntryInfo(@NotNull CharSequence shortName, boolean isDirectory, long length, long timestamp, @Nullable EntryInfo parent) {
            this.parent = parent;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }
    }
}

