/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveFileSystem
extends NewVirtualFileSystem {
    private static final Key<VirtualFile> LOCAL_FILE = Key.create((String)"vfs.archive.local.file");

    @Nullable
    public VirtualFile getRootByLocal(@NotNull VirtualFile file) {
        return this.isCorrectFileType(file) ? this.findFileByPath(this.getRootPathByLocal(file)) : null;
    }

    @NotNull
    public String getRootPathByLocal(@NotNull VirtualFile file) {
        return this.composeRootPath(file.getPath());
    }

    @Nullable
    public VirtualFile getRootByEntry(@NotNull VirtualFile entry) {
        return entry.getFileSystem() != this ? null : VfsUtil.getRootFile(entry);
    }

    @Nullable
    public VirtualFile getLocalByEntry(@NotNull VirtualFile entry) {
        if (entry.getFileSystem() != this) {
            return null;
        }
        VirtualFile root = this.getRootByEntry(entry);
        assert (root != null) : entry;
        VirtualFile local = (VirtualFile)LOCAL_FILE.get((UserDataHolder)root);
        if (local == null) {
            String localPath = this.extractLocalPath(root.getPath());
            local = StandardFileSystems.local().findFileByPath(localPath);
            if (local != null) {
                LOCAL_FILE.set((UserDataHolder)root, (Object)local);
            }
        }
        return local;
    }

    @NotNull
    protected abstract String extractLocalPath(@NotNull String var1);

    @NotNull
    protected abstract String composeRootPath(@NotNull String var1);

    @NotNull
    protected abstract ArchiveHandler getHandler(@NotNull VirtualFile var1);

    @Override
    public int getRank() {
        return LocalFileSystem.getInstance().getRank() + 1;
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @NotNull
    protected String getRelativePath(@NotNull VirtualFile file) {
        String path2 = file.getPath();
        String relativePath = path2.substring(this.extractRootPath(path2).length());
        return StringUtil.startsWithChar((CharSequence)relativePath, (char)'/') ? relativePath.substring(1) : relativePath;
    }

    @Override
    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        return this.getHandler(file).getAttributes(this.getRelativePath(file));
    }

    @Override
    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        return this.getHandler(file).list(this.getRelativePath(file));
    }

    @Override
    public boolean exists(@NotNull VirtualFile file) {
        if (file.getParent() == null) {
            return this.getLocalByEntry(file) != null;
        }
        return this.getAttributes(file) != null;
    }

    @Override
    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file.getParent() == null) {
            return true;
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes == null || attributes.isDirectory();
    }

    @Override
    public boolean isWritable(@NotNull VirtualFile file) {
        return false;
    }

    @Override
    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file);
            if (host != null) {
                return host.getTimeStamp();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file);
            if (attributes != null) {
                return attributes.lastModified;
            }
        }
        return -1L;
    }

    @Override
    public long getLength(@NotNull VirtualFile file) {
        if (file.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file);
            if (host != null) {
                return host.getLength();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file);
            if (attributes != null) {
                return attributes.length;
            }
        }
        return 0L;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        return this.getHandler(file).contentsToByteArray(this.getRelativePath(file));
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        return this.getHandler(file).getInputStream(this.getRelativePath(file));
    }

    @Override
    public void setTimeStamp(@NotNull VirtualFile file, long timeStamp) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long timeStamp) throws IOException {
        throw new IOException(VfsBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Nullable
    public VirtualFile findLocalByRootPath(@NotNull String rootPath) {
        String localPath = this.extractLocalPath(rootPath);
        VirtualFile local = StandardFileSystems.local().findFileByPath(localPath);
        return local != null && this.isCorrectFileType(local) ? local : null;
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        return FileTypeRegistry.getInstance().getFileTypeByFileName(local.getNameSequence()) == ArchiveFileType.INSTANCE;
    }
}

