/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileCopyEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myNewParent;
    private final String myNewChildName;

    public VFileCopyEvent(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String newChildName) {
        super(requestor, false);
        this.myFile = file;
        this.myNewParent = newParent;
        this.myNewChildName = newChildName;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public VirtualFile getNewParent() {
        return this.myNewParent;
    }

    @NotNull
    public String getNewChildName() {
        return this.myNewChildName;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[copy " + this.myFile + " to " + this.myNewParent + " as " + this.myNewChildName + "]";
    }

    @Override
    @NotNull
    protected String computePath() {
        return this.myNewParent.getPath() + "/" + this.myNewChildName;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myFile.getFileSystem();
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && this.myNewParent.findChild(this.myNewChildName) == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCopyEvent event = (VFileCopyEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewChildName.equals(event.myNewChildName)) {
            return false;
        }
        return this.myNewParent.equals(event.myNewParent);
    }

    @Override
    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + this.myNewParent.hashCode();
        result2 = 31 * result2 + this.myNewChildName.hashCode();
        return result2;
    }
}

