/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VFileCreateEvent
extends VFileEvent {
    @NotNull
    private final VirtualFile myParent;
    @NotNull
    private final String myChildName;
    private final boolean myDirectory;
    private final FileAttributes myAttributes;
    private final String mySymlinkTarget;
    private final boolean myEmptyDirectory;
    private VirtualFile myCreatedFile;

    public VFileCreateEvent(Object requestor, @NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, @Nullable(value="null means read from the created file") FileAttributes attributes, @Nullable String symlinkTarget, boolean isFromRefresh, boolean isEmptyDirectory) {
        super(requestor, isFromRefresh);
        this.myParent = parent;
        this.myChildName = childName;
        this.myDirectory = isDirectory;
        this.myAttributes = attributes;
        this.mySymlinkTarget = symlinkTarget;
        this.myEmptyDirectory = isEmptyDirectory;
    }

    @NotNull
    public String getChildName() {
        return this.myChildName;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    @NotNull
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Nullable
    public FileAttributes getAttributes() {
        return this.myAttributes;
    }

    @Nullable
    public String getSymlinkTarget() {
        return this.mySymlinkTarget;
    }

    public boolean isEmptyDirectory() {
        return this.isDirectory() && this.myEmptyDirectory;
    }

    @Override
    @NotNull
    protected String computePath() {
        String parentPath = this.myParent.getPath();
        return StringUtil.endsWithChar((CharSequence)parentPath, (char)'/') ? parentPath + this.myChildName : parentPath + "/" + this.myChildName;
    }

    @Override
    public VirtualFile getFile() {
        VirtualFile createdFile = this.myCreatedFile;
        if (createdFile == null) {
            this.myCreatedFile = createdFile = this.myParent.findChild(this.myChildName);
        }
        return createdFile;
    }

    public void resetCache() {
        this.myCreatedFile = null;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myParent.getFileSystem();
    }

    @Override
    public boolean isValid() {
        return this.myParent.isValid() && this.myParent.findChild(this.myChildName) == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o;
        if (this.myDirectory != event.myDirectory) {
            return false;
        }
        if (!this.myChildName.equals(event.myChildName)) {
            return false;
        }
        return this.myParent.equals(event.myParent);
    }

    @Override
    public int hashCode() {
        int result2 = this.myParent.hashCode();
        result2 = 31 * result2 + (this.myDirectory ? 1 : 0);
        result2 = 31 * result2 + this.myChildName.hashCode();
        return result2;
    }

    public String toString() {
        String kind = this.myDirectory ? (this.isEmptyDirectory() ? "(empty) " : "") + "dir " : "file ";
        return "VfsEvent[create " + kind + this.myChildName + " in " + this.myParent.getUrl() + "]";
    }
}

