/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.nio.charset.Charset;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VFilePropertyChangeEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final String myPropertyName;
    private final Object myOldValue;
    private final Object myNewValue;

    public VFilePropertyChangeEvent(Object requestor, @NotNull VirtualFile file, @VirtualFile.PropName @NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue, boolean isFromRefresh) {
        super(requestor, isFromRefresh);
        this.myFile = file;
        this.myPropertyName = propertyName;
        this.myOldValue = oldValue;
        this.myNewValue = newValue;
        VFilePropertyChangeEvent.checkPropertyValuesCorrect(requestor, propertyName, oldValue, newValue);
    }

    public static void checkPropertyValuesCorrect(Object requestor, @VirtualFile.PropName @NotNull String propertyName, Object oldValue, Object newValue) {
        if (Comparing.equal((Object)oldValue, (Object)newValue) && "FileContentUtilCore.saveOrReload" != requestor) {
            throw new IllegalArgumentException("Values must be different, got the same: " + oldValue);
        }
        switch (propertyName) {
            case "name": {
                if (oldValue == null) {
                    throw new IllegalArgumentException("oldName must not be null");
                }
                if (!(oldValue instanceof String)) {
                    throw new IllegalArgumentException("oldName must be String, got " + oldValue);
                }
                if (newValue == null) {
                    throw new IllegalArgumentException("newName must not be null");
                }
                if (newValue instanceof String) break;
                throw new IllegalArgumentException("newName must be String, got " + newValue);
            }
            case "encoding": {
                if (oldValue == null) {
                    throw new IllegalArgumentException("oldCharset must not be null");
                }
                if (oldValue instanceof Charset) break;
                throw new IllegalArgumentException("oldValue must be Charset, got " + oldValue);
            }
            case "writable": {
                if (!(oldValue instanceof Boolean)) {
                    throw new IllegalArgumentException("oldWriteable must be boolean, got " + oldValue);
                }
                if (newValue instanceof Boolean) break;
                throw new IllegalArgumentException("newWriteable must be boolean, got " + newValue);
            }
            case "HIDDEN": {
                if (!(oldValue instanceof Boolean)) {
                    throw new IllegalArgumentException("oldHidden must be boolean, got " + oldValue);
                }
                if (newValue instanceof Boolean) break;
                throw new IllegalArgumentException("newHidden must be boolean, got " + newValue);
            }
            case "symlink": {
                if (oldValue != null && !(oldValue instanceof String)) {
                    throw new IllegalArgumentException("oldSymTarget must be String, got " + oldValue);
                }
                if (newValue == null || newValue instanceof String) break;
                throw new IllegalArgumentException("newSymTarget must be String, got " + newValue);
            }
            default: {
                throw new IllegalArgumentException("Unknown property name '" + propertyName + "'. Must be one of VirtualFile.{PROP_NAME|PROP_ENCODING|PROP_WRITABLE|PROP_HIDDEN|PROP_SYMLINK_TARGET}");
            }
        }
    }

    @ApiStatus.Experimental
    public boolean isRename() {
        return this.myPropertyName == "name" && this.getRequestor() != "FileContentUtilCore.saveOrReload";
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    public Object getNewValue() {
        return this.myNewValue;
    }

    public Object getOldValue() {
        return this.myOldValue;
    }

    @NotNull
    @VirtualFile.PropName
    public String getPropertyName() {
        return this.myPropertyName;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.computePath();
    }

    @Override
    @NotNull
    protected String computePath() {
        return this.myFile.getPath();
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myFile.getFileSystem();
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFilePropertyChangeEvent event = (VFilePropertyChangeEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!Objects.equals(this.myNewValue, event.myNewValue)) {
            return false;
        }
        if (!Objects.equals(this.myOldValue, event.myOldValue)) {
            return false;
        }
        return this.myPropertyName.equals(event.myPropertyName);
    }

    @Override
    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + this.myPropertyName.hashCode();
        result2 = 31 * result2 + (this.myOldValue != null ? this.myOldValue.hashCode() : 0);
        result2 = 31 * result2 + (this.myNewValue != null ? this.myNewValue.hashCode() : 0);
        return result2;
    }

    @NotNull
    public String toString() {
        return "VfsEvent[property(" + this.myPropertyName + ") changed for '" + this.myFile + "': " + this.myOldValue + " -> " + this.myNewValue + ']';
    }

    @NotNull
    public String getOldPath() {
        String newName;
        int i;
        String path2 = this.getPath();
        if ("name".equals(this.myPropertyName) && this.myNewValue instanceof String && this.myOldValue instanceof String && (i = path2.lastIndexOf(newName = (String)this.myNewValue)) != -1) {
            path2 = new StringBuilder(path2).replace(i, i + newName.length(), (String)this.myOldValue).toString();
        }
        return path2;
    }
}

