/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolWindowManager {
    public abstract boolean canShowNotification(@NotNull String var1);

    public static ToolWindowManager getInstance(@NotNull Project project) {
        return project.getComponent(ToolWindowManager.class);
    }

    @Deprecated
    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, @NotNull JComponent var2, @NotNull ToolWindowAnchor var3);

    @Deprecated
    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, @NotNull JComponent var2, @NotNull ToolWindowAnchor var3, @NotNull Disposable var4);

    @Deprecated
    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, @NotNull JComponent var2, @NotNull ToolWindowAnchor var3, @NotNull Disposable var4, boolean var5);

    @Deprecated
    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, @NotNull JComponent var2, @NotNull ToolWindowAnchor var3, @NotNull Disposable var4, boolean var5, boolean var6);

    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, boolean var2, @NotNull ToolWindowAnchor var3);

    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, boolean var2, @NotNull ToolWindowAnchor var3, boolean var4);

    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, boolean var2, @NotNull ToolWindowAnchor var3, @NotNull Disposable var4, boolean var5);

    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, boolean var2, @NotNull ToolWindowAnchor var3, @NotNull Disposable var4, boolean var5, boolean var6);

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable) {
        return this.registerToolWindow(id, canCloseContent, anchor, parentDisposable, false);
    }

    public abstract void unregisterToolWindow(@NotNull String var1);

    public abstract void activateEditorComponent();

    public abstract boolean isEditorComponentActive();

    @NotNull
    public abstract String[] getToolWindowIds();

    @Nullable
    public abstract String getActiveToolWindowId();

    @Nullable
    public static ToolWindow getActiveToolWindow() {
        ToolWindowManager managerInstance;
        Project project;
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project project2 = project = frame == null ? ProjectManager.getInstance().getDefaultProject() : frame.getProject();
        if (project != null && (managerInstance = ToolWindowManager.getInstance(project)) != null) {
            return managerInstance.getToolWindow(ToolWindowManager.getActiveId());
        }
        return null;
    }

    @Nullable
    public static String getActiveId() {
        Project project;
        IdeFrame lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (lastFocusedFrame != null && (project = lastFocusedFrame.getProject()) != null) {
            ToolWindowManager instance = ToolWindowManager.getInstance(project);
            return instance == null ? "" : instance.getActiveToolWindowId();
        }
        return "";
    }

    public abstract ToolWindow getToolWindow(@Nullable String var1);

    public abstract void invokeLater(@NotNull Runnable var1);

    @NotNull
    public abstract IdeFocusManager getFocusManager();

    public abstract void notifyByBalloon(@NotNull String var1, @NotNull MessageType var2, @NotNull String var3);

    public abstract void notifyByBalloon(@NotNull String var1, @NotNull MessageType var2, @NotNull String var3, @Nullable Icon var4, @Nullable HyperlinkListener var5);

    @Nullable
    public abstract Balloon getToolWindowBalloon(String var1);

    public abstract boolean isMaximized(@NotNull ToolWindow var1);

    public abstract void setMaximized(@NotNull ToolWindow var1, boolean var2);
}

