/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ElementDescriptionUtil {
    private ElementDescriptionUtil() {
    }

    @NotNull
    public static String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        String result2;
        for (ElementDescriptionProvider provider : ElementDescriptionProvider.EP_NAME.getExtensionList()) {
            String result3 = provider.getElementDescription(element, location);
            if (result3 == null) continue;
            return result3;
        }
        ElementDescriptionProvider defaultProvider = location.getDefaultProvider();
        if (defaultProvider != null && (result2 = defaultProvider.getElementDescription(element, location)) != null) {
            return result2;
        }
        return element.toString();
    }
}

