/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ElementManipulators
extends ClassExtension<ElementManipulator> {
    @NonNls
    public static final String EP_NAME = "com.intellij.lang.elementManipulator";
    public static final ElementManipulators INSTANCE = new ElementManipulators();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.ElementManipulators");

    private ElementManipulators() {
        super(EP_NAME);
    }

    public static <T extends PsiElement> ElementManipulator<T> getManipulator(@NotNull T element) {
        return (ElementManipulator)INSTANCE.forClass(element.getClass());
    }

    public static int getOffsetInElement(@NotNull PsiElement element) {
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getNotNullManipulator(element);
        return ElementManipulators.getManipulatorRange(manipulator, element).getStartOffset();
    }

    @NotNull
    public static <T extends PsiElement> ElementManipulator<T> getNotNullManipulator(@NotNull T element) {
        ElementManipulator<T> manipulator = ElementManipulators.getManipulator(element);
        LOG.assertTrue(manipulator != null, (Object)element.getClass().getName());
        return manipulator;
    }

    @NotNull
    public static TextRange getValueTextRange(@NotNull PsiElement element) {
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getManipulator(element);
        return manipulator == null ? TextRange.from((int)0, (int)element.getTextLength()) : ElementManipulators.getManipulatorRange(manipulator, element);
    }

    @NotNull
    public static String getValueText(@NotNull PsiElement element) {
        TextRange valueTextRange = ElementManipulators.getValueTextRange(element);
        if (valueTextRange.isEmpty()) {
            return "";
        }
        String text = element.getText();
        if (valueTextRange.getEndOffset() > text.length()) {
            LOG.error("Wrong range for " + element + " text: " + text + " range " + valueTextRange);
        }
        return valueTextRange.substring(text);
    }

    public static <T extends PsiElement> T handleContentChange(@NotNull T element, String text) {
        ElementManipulator<T> manipulator = ElementManipulators.getNotNullManipulator(element);
        return manipulator.handleContentChange(element, text);
    }

    @NotNull
    private static TextRange getManipulatorRange(@NotNull ElementManipulator<? super PsiElement> manipulator, @NotNull PsiElement element) {
        TextRange rangeInElement = manipulator.getRangeInElement(element);
        TextRange elementRange = TextRange.from((int)0, (int)element.getTextLength());
        if (!elementRange.contains(rangeInElement)) {
            LOG.error("Element range: " + elementRange + ";\nmanipulator range: " + rangeInElement + ";\nelement: " + element.getClass() + ";\nmanipulator: " + manipulator.getClass() + ".");
        }
        return rangeInElement;
    }
}

