/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public final class LanguageSubstitutors
extends LanguageExtension<LanguageSubstitutor> {
    public static final LanguageSubstitutors INSTANCE = new LanguageSubstitutors();
    private static final Logger LOG = Logger.getInstance(LanguageSubstitutors.class);
    private static final Key<Key<Language>> PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY = Key.create((String)"PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY");
    private static final AtomicBoolean REQUESTS_DRAIN_NEEDED = new AtomicBoolean(true);
    private static final ConcurrentMap<VirtualFile, SubstitutionInfo> ourReparsingRequests = ContainerUtil.newConcurrentMap();

    private LanguageSubstitutors() {
        super("com.intellij.lang.substitutor");
    }

    @NotNull
    public Language substituteLanguage(@NotNull Language originalLang, @NotNull VirtualFile file, @NotNull Project project) {
        for (LanguageSubstitutor substitutor : this.forKey(originalLang)) {
            Language substitutedLang = substitutor.getLanguage(file, project);
            if (substitutedLang == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("For " + (Object)((Object)originalLang) + " and " + file + ", " + substitutor.getClass().getName() + " returned '" + (Object)((Object)substitutedLang) + "' of " + ((Object)((Object)substitutedLang)).getClass());
            }
            LanguageSubstitutors.processLanguageSubstitution(file, originalLang, substitutedLang, project);
            return substitutedLang;
        }
        return originalLang;
    }

    private static void processLanguageSubstitution(@NotNull VirtualFile file, @NotNull Language originalLang, @NotNull Language substitutedLang, @NotNull Project project) {
        if (file instanceof VirtualFileWindow) {
            return;
        }
        Key<Language> projectKey = LanguageSubstitutors.getOrCreateProjectKey(project);
        Language prevSubstitutedLang = (Language)((Object)projectKey.get((UserDataHolder)file));
        Language prevLang = (Language)((Object)ObjectUtils.notNull((Object)((Object)prevSubstitutedLang), (Object)((Object)originalLang)));
        if (!prevLang.is(substitutedLang) && file.replace(projectKey, (Object)prevSubstitutedLang, (Object)substitutedLang)) {
            if (prevSubstitutedLang == null) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            LanguageSubstitutors.requestReparsing(file, prevLang, substitutedLang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Key<Language> getOrCreateProjectKey(@NotNull Project project) {
        Key key = (Key)PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get((UserDataHolder)project);
        if (key == null) {
            Key<Key<Language>> key2 = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY;
            synchronized (key2) {
                key = (Key)PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get((UserDataHolder)project);
                if (key == null) {
                    key = new Key("Substituted lang key for " + project.getName());
                    PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.set((UserDataHolder)project, (Object)key);
                }
            }
        }
        return key;
    }

    private static void requestReparsing(@NotNull VirtualFile file, @NotNull Language prevLang, @NotNull Language substitutedLang) {
        ourReparsingRequests.put(file, new SubstitutionInfo(prevLang, substitutedLang));
        if (REQUESTS_DRAIN_NEEDED.compareAndSet(true, false)) {
            TransactionGuard.getInstance().submitTransactionLater(ApplicationManager.getApplication(), () -> {
                REQUESTS_DRAIN_NEEDED.set(true);
                ArrayList set = ContainerUtil.newArrayList(ourReparsingRequests.entrySet());
                ArrayList files = ContainerUtil.newArrayListWithCapacity((int)set.size());
                int id = 1;
                for (Map.Entry entry : set) {
                    VirtualFile f = (VirtualFile)entry.getKey();
                    SubstitutionInfo info = (SubstitutionInfo)entry.getValue();
                    ourReparsingRequests.remove(f);
                    if (!f.isValid()) continue;
                    LOG.info("Reparsing " + f.getPath() + " because of language substitution " + info.myPrevLang.getID() + "->" + info.mySubstitutedLang.getID() + ", #" + id++);
                    files.add(f);
                }
                if (files.size() > 0) {
                    FileContentUtilCore.reparseFiles(files);
                }
            });
        }
    }

    public static void cancelReparsing(@NotNull VirtualFile file) {
        ourReparsingRequests.remove(file);
    }

    private static class SubstitutionInfo {
        private final Language myPrevLang;
        private final Language mySubstitutedLang;

        SubstitutionInfo(@NotNull Language prevLang, @NotNull Language substitutedLang) {
            this.myPrevLang = prevLang;
            this.mySubstitutedLang = substitutedLang;
        }
    }
}

