/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReferenceRange {
    private ReferenceRange() {
    }

    @NotNull
    public static List<TextRange> getRanges(@NotNull PsiReference ref) {
        if (ref instanceof MultiRangeReference) {
            return ((MultiRangeReference)ref).getRanges();
        }
        return Collections.singletonList(ref.getRangeInElement());
    }

    @NotNull
    public static List<TextRange> getAbsoluteRanges(@NotNull PsiReference ref) {
        PsiElement elt = ref.getElement();
        List<TextRange> relativeRanges = ReferenceRange.getRanges(ref);
        ArrayList<TextRange> answer = new ArrayList<TextRange>(relativeRanges.size());
        int parentOffset = elt.getTextRange().getStartOffset();
        for (TextRange relativeRange : relativeRanges) {
            answer.add(relativeRange.shiftRight(parentOffset));
        }
        return answer;
    }

    public static TextRange getRange(@NotNull PsiReference ref) {
        if (ref instanceof MultiRangeReference) {
            List<TextRange> ranges2 = ((MultiRangeReference)ref).getRanges();
            return new TextRange(ranges2.get(0).getStartOffset(), ranges2.get(ranges2.size() - 1).getEndOffset());
        }
        return ref.getRangeInElement();
    }

    public static boolean containsOffsetInElement(@NotNull PsiReference ref, int offset) {
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.containsOffset(offset)) continue;
                return true;
            }
            return false;
        }
        TextRange rangeInElement = ref.getRangeInElement();
        return rangeInElement != null && rangeInElement.containsOffset(offset);
    }

    public static boolean containsRangeInElement(@NotNull PsiReference ref, @NotNull TextRange rangeInElement) {
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.contains(rangeInElement)) continue;
                return true;
            }
            return false;
        }
        TextRange rangeInElement1 = ref.getRangeInElement();
        return rangeInElement1 != null && rangeInElement1.contains(rangeInElement);
    }
}

