/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingComparable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeighingService {
    private static final KeyedExtensionCollector<Weigher, Key> COLLECTOR = new KeyedExtensionCollector<Weigher, Key>("com.intellij.weigher"){

        @Override
        @NotNull
        protected String keyToString(@NotNull Key key) {
            return key.toString();
        }
    };

    private WeighingService() {
    }

    @NotNull
    public static <T, Loc> WeighingComparable<T, Loc> weigh(Key<? extends Weigher<T, Loc>> key, T element, @Nullable Loc location) {
        return WeighingService.weigh(key, new Computable.PredefinedValueComputable(element), location);
    }

    @NotNull
    public static <T, Loc> WeighingComparable<T, Loc> weigh(Key<? extends Weigher<T, Loc>> key, Computable<? extends T> element, @Nullable Loc location) {
        List<Weigher> weighers = WeighingService.getWeighers(key);
        return new WeighingComparable<T, Loc>(element, location, weighers.toArray(new Weigher[0]));
    }

    public static <T, Loc> List<Weigher> getWeighers(Key<? extends Weigher<T, Loc>> key) {
        return COLLECTOR.forKey(key);
    }
}

