/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.formatting.FormattingMode;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleManager {
    public static CodeStyleManager getInstance(@NotNull Project project) {
        return ServiceManager.getService(project, CodeStyleManager.class);
    }

    public static CodeStyleManager getInstance(@NotNull PsiManager manager) {
        return CodeStyleManager.getInstance(manager.getProject());
    }

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1, boolean var2) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3, boolean var4) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, @NotNull Collection<TextRange> var2) throws IncorrectOperationException;

    public abstract void reformatTextWithContext(@NotNull PsiFile var1, @NotNull ChangedRangesInfo var2) throws IncorrectOperationException;

    public void reformatTextWithContext(@NotNull PsiFile file, @NotNull Collection<TextRange> ranges2) throws IncorrectOperationException {
        ArrayList rangesList = ContainerUtil.newArrayList(ranges2);
        this.reformatTextWithContext(file, new ChangedRangesInfo(rangesList, null));
    }

    public abstract void adjustLineIndent(@NotNull PsiFile var1, TextRange var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull PsiFile var1, int var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull Document var1, int var2);

    @Deprecated
    public abstract boolean isLineToBeIndented(@NotNull PsiFile var1, int var2);

    @Nullable
    public abstract String getLineIndent(@NotNull PsiFile var1, int var2);

    @Nullable
    public String getLineIndent(@NotNull PsiFile file, int offset, FormattingMode mode) {
        return this.getLineIndent(file, offset);
    }

    @Nullable
    public abstract String getLineIndent(@NotNull Document var1, int var2);

    @Deprecated
    public abstract Indent getIndent(String var1, FileType var2);

    @Deprecated
    public abstract String fillIndent(Indent var1, FileType var2);

    @Deprecated
    public abstract Indent zeroIndent();

    public abstract void reformatNewlyAddedElement(@NotNull ASTNode var1, @NotNull ASTNode var2) throws IncorrectOperationException;

    public abstract boolean isSequentialProcessingAllowed();

    public abstract void performActionWithFormatterDisabled(Runnable var1);

    public abstract <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> var1) throws T;

    public abstract <T> T performActionWithFormatterDisabled(Computable<T> var1);

    public int getSpacing(@NotNull PsiFile file, int offset) {
        return -1;
    }

    public int getMinLineFeeds(@NotNull PsiFile file, int offset) {
        return -1;
    }

    public static FormattingMode getCurrentFormattingMode(@NotNull Project project) {
        CodeStyleManager instance;
        if (!project.isDisposed() && (instance = CodeStyleManager.getInstance(project)) instanceof FormattingModeAwareIndentAdjuster) {
            return ((FormattingModeAwareIndentAdjuster)((Object)instance)).getCurrentFormattingMode();
        }
        return FormattingMode.REFORMAT;
    }

    public void runWithDocCommentFormattingDisabled(@NotNull PsiFile file, @NotNull Runnable runnable) {
        runnable.run();
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull PsiFile file) {
        return DocCommentSettings.DEFAULTS;
    }
}

