/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.configurationStore.Property;
import com.intellij.configurationStore.UnknownElementCollector;
import com.intellij.configurationStore.UnknownElementWriter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.ExcludedFiles;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsProvider;
import com.intellij.psi.codeStyle.ImportsLayoutSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.LegacyCodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.psi.codeStyle.SoftMargins;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ClassMap;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettings
extends LegacyCodeStyleSettings
implements Cloneable,
JDOMExternalizable,
ImportsLayoutSettings {
    public static final int CURR_VERSION = 173;
    private static final Logger LOG = Logger.getInstance(CodeStyleSettings.class);
    public static final String VERSION_ATTR = "version";
    private final ClassMap<CustomCodeStyleSettings> myCustomSettings = new ClassMap();
    @NonNls
    private static final String REPEAT_ANNOTATIONS = "REPEAT_ANNOTATIONS";
    @NonNls
    private static final String ADDITIONAL_INDENT_OPTIONS = "ADDITIONAL_INDENT_OPTIONS";
    @NonNls
    private static final String FILETYPE = "fileType";
    private CommonCodeStyleSettingsManager myCommonSettingsManager = new CommonCodeStyleSettingsManager(this);
    private UnknownElementWriter myUnknownElementWriter = UnknownElementWriter.EMPTY;
    private final SoftMargins mySoftMargins = new SoftMargins();
    private final ExcludedFiles myExcludedFiles = new ExcludedFiles();
    private int myVersion = 173;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();
    public boolean USE_SAME_INDENTS;
    public boolean IGNORE_SAME_INDENTS_FOR_LANGUAGES;
    public boolean AUTODETECT_INDENTS = true;
    public final CommonCodeStyleSettings.IndentOptions OTHER_INDENT_OPTIONS = new CommonCodeStyleSettings.IndentOptions();
    private final Map<FileType, CommonCodeStyleSettings.IndentOptions> myAdditionalIndentOptions = new LinkedHashMap<FileType, CommonCodeStyleSettings.IndentOptions>();
    private static final String ourSystemLineSeparator = SystemProperties.getLineSeparator();
    public String LINE_SEPARATOR;
    @Deprecated
    public String FIELD_NAME_PREFIX = "";
    @Deprecated
    public String STATIC_FIELD_NAME_PREFIX = "";
    @Deprecated
    public String PARAMETER_NAME_PREFIX = "";
    @Deprecated
    public String LOCAL_VARIABLE_NAME_PREFIX = "";
    @Deprecated
    public String FIELD_NAME_SUFFIX = "";
    @Deprecated
    public String STATIC_FIELD_NAME_SUFFIX = "";
    @Deprecated
    public String PARAMETER_NAME_SUFFIX = "";
    @Deprecated
    public String LOCAL_VARIABLE_NAME_SUFFIX = "";
    @Deprecated
    public boolean PREFER_LONGER_NAMES = true;
    @Deprecated
    public final TypeToNameMap FIELD_TYPE_TO_NAME = new TypeToNameMap();
    @Deprecated
    public final TypeToNameMap STATIC_FIELD_TYPE_TO_NAME = new TypeToNameMap();
    @Deprecated
    @NonNls
    public final TypeToNameMap PARAMETER_TYPE_TO_NAME = new TypeToNameMap();
    @Deprecated
    public final TypeToNameMap LOCAL_VARIABLE_TYPE_TO_NAME = new TypeToNameMap();
    @Deprecated
    public boolean GENERATE_FINAL_LOCALS;
    @Deprecated
    public boolean GENERATE_FINAL_PARAMETERS;
    @Deprecated
    public String VISIBILITY = "public";
    @Deprecated
    public boolean PARENTHESES_AROUND_METHOD_ARGUMENTS = true;
    @Deprecated
    public boolean USE_EXTERNAL_ANNOTATIONS;
    @Deprecated
    public boolean INSERT_OVERRIDE_ANNOTATION = true;
    @Deprecated
    public boolean REPEAT_SYNCHRONIZED = true;
    private final List<String> myRepeatAnnotations = new ArrayList<String>();
    @Deprecated
    public boolean REPLACE_INSTANCEOF;
    @Deprecated
    public boolean REPLACE_CAST;
    @Deprecated
    public boolean REPLACE_NULL_CHECK = true;
    @Deprecated
    public boolean LAYOUT_STATIC_IMPORTS_SEPARATELY = true;
    @Deprecated
    public boolean USE_FQ_CLASS_NAMES;
    @Deprecated
    public boolean USE_FQ_CLASS_NAMES_IN_JAVADOC = true;
    @Deprecated
    public boolean USE_SINGLE_CLASS_IMPORTS = true;
    @Deprecated
    public boolean INSERT_INNER_CLASS_IMPORTS;
    @Deprecated
    public int CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = 5;
    @Deprecated
    public int NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = 3;
    @Deprecated
    public final PackageEntryTable PACKAGES_TO_USE_IMPORT_ON_DEMAND = new PackageEntryTable();
    @Deprecated
    public final PackageEntryTable IMPORT_LAYOUT_TABLE = new PackageEntryTable();
    @Deprecated
    public int STATIC_FIELDS_ORDER_WEIGHT = 1;
    @Deprecated
    public int FIELDS_ORDER_WEIGHT = 2;
    @Deprecated
    public int CONSTRUCTORS_ORDER_WEIGHT = 3;
    @Deprecated
    public int STATIC_METHODS_ORDER_WEIGHT = 4;
    @Deprecated
    public int METHODS_ORDER_WEIGHT = 5;
    @Deprecated
    public int STATIC_INNER_CLASSES_ORDER_WEIGHT = 6;
    @Deprecated
    public int INNER_CLASSES_ORDER_WEIGHT = 7;
    @Property(externalName="max_line_length")
    public int RIGHT_MARGIN = 120;
    @Property(externalName="wrap_on_typing")
    public boolean WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN;
    @Deprecated
    public boolean ENABLE_JAVADOC_FORMATTING = true;
    @Deprecated
    public boolean JD_ALIGN_PARAM_COMMENTS = true;
    @Deprecated
    public boolean JD_ALIGN_EXCEPTION_COMMENTS = true;
    @Deprecated
    public boolean JD_ADD_BLANK_AFTER_PARM_COMMENTS;
    @Deprecated
    public boolean JD_ADD_BLANK_AFTER_RETURN;
    @Deprecated
    public boolean JD_ADD_BLANK_AFTER_DESCRIPTION = true;
    @Deprecated
    public boolean JD_P_AT_EMPTY_LINES = true;
    @Deprecated
    public boolean JD_KEEP_INVALID_TAGS = true;
    @Deprecated
    public boolean JD_KEEP_EMPTY_LINES = true;
    @Deprecated
    public boolean JD_DO_NOT_WRAP_ONE_LINE_COMMENTS;
    @Deprecated
    public boolean JD_USE_THROWS_NOT_EXCEPTION = true;
    @Deprecated
    public boolean JD_KEEP_EMPTY_PARAMETER = true;
    @Deprecated
    public boolean JD_KEEP_EMPTY_EXCEPTION = true;
    @Deprecated
    public boolean JD_KEEP_EMPTY_RETURN = true;
    @Deprecated
    public boolean JD_LEADING_ASTERISKS_ARE_ENABLED = true;
    @Deprecated
    public boolean JD_PRESERVE_LINE_FEEDS;
    @Deprecated
    public boolean JD_PARAM_DESCRIPTION_ON_NEW_LINE;
    @Deprecated
    public boolean JD_INDENT_ON_CONTINUATION;
    @Deprecated
    public boolean HTML_KEEP_WHITESPACES;
    @Deprecated
    public int HTML_ATTRIBUTE_WRAP = 1;
    @Deprecated
    public int HTML_TEXT_WRAP = 1;
    @Deprecated
    public boolean HTML_KEEP_LINE_BREAKS = true;
    @Deprecated
    public boolean HTML_KEEP_LINE_BREAKS_IN_TEXT = true;
    @Deprecated
    public int HTML_KEEP_BLANK_LINES = 2;
    @Deprecated
    public boolean HTML_ALIGN_ATTRIBUTES = true;
    @Deprecated
    public boolean HTML_ALIGN_TEXT;
    @Deprecated
    public boolean HTML_SPACE_AROUND_EQUALITY_IN_ATTRINUTE;
    @Deprecated
    public boolean HTML_SPACE_AFTER_TAG_NAME;
    @Deprecated
    public boolean HTML_SPACE_INSIDE_EMPTY_TAG;
    @Deprecated
    @NonNls
    public String HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE = "body,div,p,form,h1,h2,h3";
    @Deprecated
    @NonNls
    public String HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE = "br";
    @Deprecated
    @NonNls
    public String HTML_DO_NOT_INDENT_CHILDREN_OF = "html,body,thead,tbody,tfoot";
    @Deprecated
    public int HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES;
    @Deprecated
    @NonNls
    public String HTML_KEEP_WHITESPACES_INSIDE = "span,pre,textarea";
    @Deprecated
    @NonNls
    public String HTML_INLINE_ELEMENTS = "a,abbr,acronym,b,basefont,bdo,big,br,cite,cite,code,dfn,em,font,i,img,input,kbd,label,q,s,samp,select,span,strike,strong,sub,sup,textarea,tt,u,var";
    @Deprecated
    @NonNls
    public String HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT = "title,h1,h2,h3,h4,h5,h6,p";
    @Deprecated
    public QuoteStyle HTML_QUOTE_STYLE = QuoteStyle.Double;
    @Deprecated
    public boolean HTML_ENFORCE_QUOTES;
    @Deprecated
    public HtmlTagNewLineStyle HTML_NEWLINE_BEFORE_FIRST_ATTRIBUTE = HtmlTagNewLineStyle.Never;
    @Deprecated
    public HtmlTagNewLineStyle HTML_NEWLINE_AFTER_LAST_ATTRIBUTE = HtmlTagNewLineStyle.Never;
    @Deprecated
    public boolean JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST;
    public boolean FORMATTER_TAGS_ENABLED;
    public String FORMATTER_ON_TAG = "@formatter:on";
    public String FORMATTER_OFF_TAG = "@formatter:off";
    public volatile boolean FORMATTER_TAGS_ACCEPT_REGEXP;
    private volatile Pattern myFormatterOffPattern;
    private volatile Pattern myFormatterOnPattern;
    private CodeStyleSettings myParentSettings;
    private boolean myLoadedAdditionalIndentOptions;

    public CodeStyleSettings() {
        this(true);
    }

    public CodeStyleSettings(boolean loadExtensions) {
        this.initTypeToName();
        this.initImportsByDefault();
        if (loadExtensions) {
            for (CodeStyleSettingsProvider codeStyleSettingsProvider : CodeStyleSettingsProvider.EXTENSION_POINT_NAME.getExtensionList()) {
                this.addCustomSettings(codeStyleSettingsProvider.createCustomSettings(this));
            }
            for (CodeStyleSettingsProvider codeStyleSettingsProvider : LanguageCodeStyleSettingsProvider.getSettingsPagesProviders()) {
                this.addCustomSettings(codeStyleSettingsProvider.createCustomSettings(this));
            }
            for (PredefinedCodeStyle predefinedCodeStyle : PredefinedCodeStyle.EP_NAME.getExtensionList()) {
                if (!"Android".equals(predefinedCodeStyle.getName())) continue;
                predefinedCodeStyle.apply(this);
            }
        }
    }

    private void initImportsByDefault() {
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "java.awt", false));
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "javax.swing", false));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "javax", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "java", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
    }

    private void initTypeToName() {
        CodeStyleSettings.initGeneralLocalVariable(this.PARAMETER_TYPE_TO_NAME);
        CodeStyleSettings.initGeneralLocalVariable(this.LOCAL_VARIABLE_TYPE_TO_NAME);
        this.PARAMETER_TYPE_TO_NAME.addPair("*Exception", "e");
    }

    private static void initGeneralLocalVariable(@NonNls TypeToNameMap map) {
        map.addPair("int", "i");
        map.addPair("byte", "b");
        map.addPair("char", "c");
        map.addPair("long", "l");
        map.addPair("short", "i");
        map.addPair("boolean", "b");
        map.addPair("double", "v");
        map.addPair("float", "v");
        map.addPair("java.lang.Object", "o");
        map.addPair("java.lang.String", "s");
    }

    public void setParentSettings(CodeStyleSettings parent) {
        this.myParentSettings = parent;
    }

    public CodeStyleSettings getParentSettings() {
        return this.myParentSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCustomSettings(CustomCodeStyleSettings settings) {
        if (settings != null) {
            ClassMap<CustomCodeStyleSettings> classMap = this.myCustomSettings;
            synchronized (classMap) {
                this.myCustomSettings.put(settings.getClass(), (Object)settings);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull Class<T> aClass) {
        ClassMap<CustomCodeStyleSettings> classMap = this.myCustomSettings;
        synchronized (classMap) {
            CustomCodeStyleSettings result2 = (CustomCodeStyleSettings)this.myCustomSettings.get(aClass);
            if (result2 == null) {
                throw new RuntimeException("Unable to get registered settings of #" + aClass.getSimpleName() + " (" + aClass.getName() + ")");
            }
            return (T)result2;
        }
    }

    public CodeStyleSettings clone() {
        CodeStyleSettings clone = new CodeStyleSettings();
        clone.copyFrom(this);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCustomSettingsFrom(@NotNull CodeStyleSettings from) {
        ClassMap<CustomCodeStyleSettings> classMap = this.myCustomSettings;
        synchronized (classMap) {
            this.myCustomSettings.clear();
            for (CustomCodeStyleSettings customCodeStyleSettings : from.getCustomSettingsValues()) {
                CustomCodeStyleSettings clone = (CustomCodeStyleSettings)customCodeStyleSettings.clone();
                clone.setContainer(this);
                this.addCustomSettings(clone);
            }
            this.FIELD_TYPE_TO_NAME.copyFrom(from.FIELD_TYPE_TO_NAME);
            this.STATIC_FIELD_TYPE_TO_NAME.copyFrom(from.STATIC_FIELD_TYPE_TO_NAME);
            this.PARAMETER_TYPE_TO_NAME.copyFrom(from.PARAMETER_TYPE_TO_NAME);
            this.LOCAL_VARIABLE_TYPE_TO_NAME.copyFrom(from.LOCAL_VARIABLE_TYPE_TO_NAME);
            this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(from.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
            this.IMPORT_LAYOUT_TABLE.copyFrom(from.IMPORT_LAYOUT_TABLE);
            this.OTHER_INDENT_OPTIONS.copyFrom(from.OTHER_INDENT_OPTIONS);
            this.myAdditionalIndentOptions.clear();
            for (Map.Entry entry : from.myAdditionalIndentOptions.entrySet()) {
                CommonCodeStyleSettings.IndentOptions options = (CommonCodeStyleSettings.IndentOptions)entry.getValue();
                this.myAdditionalIndentOptions.put((FileType)entry.getKey(), (CommonCodeStyleSettings.IndentOptions)options.clone());
            }
            this.myCommonSettingsManager = from.myCommonSettingsManager.clone(this);
            this.myRepeatAnnotations.clear();
            this.myRepeatAnnotations.addAll(from.myRepeatAnnotations);
        }
    }

    public void copyFrom(CodeStyleSettings from) {
        CommonCodeStyleSettings.copyPublicFields(from, this);
        CommonCodeStyleSettings.copyPublicFields(from.OTHER_INDENT_OPTIONS, this.OTHER_INDENT_OPTIONS);
        this.mySoftMargins.setValues(from.getDefaultSoftMargins());
        this.myExcludedFiles.setDescriptors(from.getExcludedFiles().getDescriptors());
        this.copyCustomSettingsFrom(from);
    }

    public String getLineSeparator() {
        return this.LINE_SEPARATOR != null ? this.LINE_SEPARATOR : ourSystemLineSeparator;
    }

    @Deprecated
    public List<String> getRepeatAnnotations() {
        return this.myRepeatAnnotations;
    }

    @Deprecated
    public void setRepeatAnnotations(List<String> repeatAnnotations) {
        this.myRepeatAnnotations.clear();
        this.myRepeatAnnotations.addAll(repeatAnnotations);
    }

    @Override
    @Deprecated
    public boolean isLayoutStaticImportsSeparately() {
        return this.LAYOUT_STATIC_IMPORTS_SEPARATELY;
    }

    @Override
    @Deprecated
    public void setLayoutStaticImportsSeparately(boolean value) {
        this.LAYOUT_STATIC_IMPORTS_SEPARATELY = value;
    }

    @Override
    @Deprecated
    public int getNamesCountToUseImportOnDemand() {
        return this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    @Override
    @Deprecated
    public void setNamesCountToUseImportOnDemand(int value) {
        this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    @Override
    @Deprecated
    public int getClassCountToUseImportOnDemand() {
        return this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    @Override
    @Deprecated
    public void setClassCountToUseImportOnDemand(int value) {
        this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    @Override
    @Deprecated
    public boolean isInsertInnerClassImports() {
        return this.INSERT_INNER_CLASS_IMPORTS;
    }

    @Override
    @Deprecated
    public void setInsertInnerClassImports(boolean value) {
        this.INSERT_INNER_CLASS_IMPORTS = value;
    }

    @Override
    @Deprecated
    public boolean isUseSingleClassImports() {
        return this.USE_SINGLE_CLASS_IMPORTS;
    }

    @Override
    @Deprecated
    public void setUseSingleClassImports(boolean value) {
        this.USE_SINGLE_CLASS_IMPORTS = value;
    }

    @Override
    @Deprecated
    public boolean isUseFqClassNames() {
        return this.USE_FQ_CLASS_NAMES;
    }

    @Override
    @Deprecated
    public void setUseFqClassNames(boolean value) {
        this.USE_FQ_CLASS_NAMES = value;
    }

    @Override
    @Deprecated
    public PackageEntryTable getImportLayoutTable() {
        return this.IMPORT_LAYOUT_TABLE;
    }

    @Override
    @Deprecated
    public PackageEntryTable getPackagesToUseImportOnDemand() {
        return this.PACKAGES_TO_USE_IMPORT_ON_DEMAND;
    }

    @Nullable
    public Pattern getFormatterOffPattern() {
        if (this.myFormatterOffPattern == null && this.FORMATTER_TAGS_ENABLED && this.FORMATTER_TAGS_ACCEPT_REGEXP) {
            this.myFormatterOffPattern = this.getPatternOrDisableRegexp(this.FORMATTER_OFF_TAG);
        }
        return this.myFormatterOffPattern;
    }

    public void setFormatterOffPattern(@Nullable Pattern formatterOffPattern) {
        this.myFormatterOffPattern = formatterOffPattern;
    }

    @Nullable
    public Pattern getFormatterOnPattern() {
        if (this.myFormatterOffPattern == null && this.FORMATTER_TAGS_ENABLED && this.FORMATTER_TAGS_ACCEPT_REGEXP) {
            this.myFormatterOnPattern = this.getPatternOrDisableRegexp(this.FORMATTER_ON_TAG);
        }
        return this.myFormatterOnPattern;
    }

    public void setFormatterOnPattern(@Nullable Pattern formatterOnPattern) {
        this.myFormatterOnPattern = formatterOnPattern;
    }

    @Nullable
    private Pattern getPatternOrDisableRegexp(@NotNull String markerText) {
        try {
            return Pattern.compile(markerText);
        }
        catch (PatternSyntaxException pse) {
            LOG.error("Loaded regexp pattern is invalid: '" + markerText + "', error message: " + pse.getMessage());
            this.FORMATTER_TAGS_ACCEPT_REGEXP = false;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Collection<CustomCodeStyleSettings> getCustomSettingsValues() {
        ClassMap<CustomCodeStyleSettings> classMap = this.myCustomSettings;
        synchronized (classMap) {
            return Collections.unmodifiableCollection(this.myCustomSettings.values());
        }
    }

    private static void setVersion(@NotNull Element element, int version) {
        element.setAttribute(VERSION_ATTR, Integer.toString(version));
    }

    private static int getVersion(@NotNull Element element) {
        String versionStr = element.getAttributeValue(VERSION_ATTR);
        if (versionStr == null) {
            return 0;
        }
        try {
            return Integer.parseInt(versionStr);
        }
        catch (NumberFormatException nfe) {
            return 173;
        }
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        this.myVersion = CodeStyleSettings.getVersion(element);
        this.notifySettingsBeforeLoading();
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        if (this.LAYOUT_STATIC_IMPORTS_SEPARATELY) {
            boolean found = false;
            for (PackageEntry entry : this.IMPORT_LAYOUT_TABLE.getEntries()) {
                if (entry != PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) continue;
                found = true;
                break;
            }
            if (!found) {
                Iterator last;
                Iterator iterator = last = this.IMPORT_LAYOUT_TABLE.getEntryCount() == 0 ? null : this.IMPORT_LAYOUT_TABLE.getEntryAt(this.IMPORT_LAYOUT_TABLE.getEntryCount() - 1);
                if (last != PackageEntry.BLANK_LINE_ENTRY) {
                    this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                }
                this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
            }
        }
        this.myRepeatAnnotations.clear();
        Element annotations = element.getChild(REPEAT_ANNOTATIONS);
        if (annotations != null) {
            for (Element anno : annotations.getChildren("ANNO")) {
                this.myRepeatAnnotations.add(anno.getAttributeValue("name"));
            }
        }
        UnknownElementCollector unknownElementCollector = new UnknownElementCollector();
        for (CustomCodeStyleSettings settings : this.getCustomSettingsValues()) {
            settings.getKnownTagNames().forEach(unknownElementCollector::addKnownName);
            settings.readExternal(element);
        }
        unknownElementCollector.addKnownName(ADDITIONAL_INDENT_OPTIONS);
        List list = element.getChildren(ADDITIONAL_INDENT_OPTIONS);
        for (Element additionalIndentElement : list) {
            String fileTypeId = additionalIndentElement.getAttributeValue(FILETYPE);
            if (StringUtil.isEmpty((String)fileTypeId)) continue;
            FileType target = FileTypeManager.getInstance().getFileTypeByExtension(fileTypeId);
            if (FileTypes.UNKNOWN == target || FileTypes.PLAIN_TEXT == target || target.getDefaultExtension().isEmpty()) {
                target = new TempFileType(fileTypeId);
            }
            CommonCodeStyleSettings.IndentOptions options = CodeStyleSettings.getDefaultIndentOptions(target);
            options.readExternal(additionalIndentElement);
            this.registerAdditionalIndentOptions(target, options);
        }
        unknownElementCollector.addKnownName("codeStyleSettings");
        this.myCommonSettingsManager.readExternal(element);
        this.myUnknownElementWriter = unknownElementCollector.createWriter(element);
        if (this.USE_SAME_INDENTS) {
            this.IGNORE_SAME_INDENTS_FOR_LANGUAGES = true;
        }
        this.mySoftMargins.deserializeFrom(element);
        this.myExcludedFiles.deserializeFrom(element);
        this.migrateLegacySettings();
        this.notifySettingsLoaded();
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        CodeStyleSettings.setVersion(element, this.myVersion);
        CodeStyleSettings parentSettings = new CodeStyleSettings();
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter((Object)this, (Object)parentSettings));
        this.mySoftMargins.serializeInto(element);
        this.myExcludedFiles.serializeInto(element);
        this.myUnknownElementWriter.write(element, this.getCustomSettingsValues(), CustomCodeStyleSettings::getTagName, settings -> {
            Object parentCustomSettings = parentSettings.getCustomSettings(settings.getClass());
            settings.writeExternal(element, (CustomCodeStyleSettings)parentCustomSettings);
        });
        if (!this.myAdditionalIndentOptions.isEmpty()) {
            FileType[] fileTypes = this.myAdditionalIndentOptions.keySet().toArray(FileType.EMPTY_ARRAY);
            Arrays.sort(fileTypes, Comparator.comparing(FileType::getDefaultExtension));
            for (FileType fileType : fileTypes) {
                Element additionalIndentOptions = new Element(ADDITIONAL_INDENT_OPTIONS);
                this.myAdditionalIndentOptions.get(fileType).serialize(additionalIndentOptions, CodeStyleSettings.getDefaultIndentOptions(fileType));
                additionalIndentOptions.setAttribute(FILETYPE, fileType.getDefaultExtension());
                if (additionalIndentOptions.getChildren().isEmpty()) continue;
                element.addContent(additionalIndentOptions);
            }
        }
        this.myCommonSettingsManager.writeExternal(element);
        if (!this.myRepeatAnnotations.isEmpty()) {
            Element annos = new Element(REPEAT_ANNOTATIONS);
            for (String annotation : this.myRepeatAnnotations) {
                annos.addContent(new Element("ANNO").setAttribute("name", annotation));
            }
            element.addContent(annos);
        }
    }

    private static CommonCodeStyleSettings.IndentOptions getDefaultIndentOptions(FileType fileType) {
        for (FileTypeIndentOptionsProvider provider : FileTypeIndentOptionsProvider.EP_NAME.getExtensionList()) {
            if (!provider.getFileType().equals(fileType)) continue;
            return CodeStyleSettings.getFileTypeIndentOptions(provider);
        }
        return new CommonCodeStyleSettings.IndentOptions();
    }

    @Override
    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        return this.OTHER_INDENT_OPTIONS;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@Nullable FileType fileType) {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getLanguageIndentOptions(fileType);
        if (indentOptions != null) {
            return indentOptions;
        }
        if (this.USE_SAME_INDENTS || fileType == null) {
            return this.OTHER_INDENT_OPTIONS;
        }
        if (!this.myLoadedAdditionalIndentOptions) {
            this.loadAdditionalIndentOptions();
        }
        if ((indentOptions = this.myAdditionalIndentOptions.get(fileType)) != null) {
            return indentOptions;
        }
        return this.OTHER_INDENT_OPTIONS;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByDocument(@Nullable Project project, @NotNull Document document) {
        PsiFile file;
        PsiFile psiFile = file = project != null ? PsiDocumentManager.getInstance(project).getPsiFile(document) : null;
        if (file != null) {
            return this.getIndentOptionsByFile(file);
        }
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
        FileType fileType = vFile != null ? vFile.getFileType() : null;
        return this.getIndentOptions(fileType);
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@Nullable PsiFile file) {
        return this.getIndentOptionsByFile(file, null);
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@Nullable PsiFile file, @Nullable TextRange formatRange) {
        return this.getIndentOptionsByFile(file, formatRange, false, null);
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@Nullable PsiFile file, @Nullable TextRange formatRange, boolean ignoreDocOptions, @Nullable Processor<? super FileIndentOptionsProvider> providerProcessor) {
        if (file != null && file.isValid()) {
            CommonCodeStyleSettings.IndentOptions options;
            Object options2;
            boolean isFullReformat = CodeStyleSettings.isFileFullyCoveredByRange(file, formatRange);
            if (!ignoreDocOptions && !isFullReformat && (options2 = CommonCodeStyleSettings.IndentOptions.retrieveFromAssociatedDocument(file)) != null) {
                FileIndentOptionsProvider provider = ((CommonCodeStyleSettings.IndentOptions)options2).getFileIndentOptionsProvider();
                if (providerProcessor != null && provider != null) {
                    providerProcessor.process((Object)provider);
                }
                return options2;
            }
            for (FileIndentOptionsProvider provider : FileIndentOptionsProvider.EP_NAME.getExtensionList()) {
                CommonCodeStyleSettings.IndentOptions indentOptions;
                if (isFullReformat && !provider.useOnFullReformat() || (indentOptions = provider.getIndentOptions(this, file)) == null) continue;
                if (providerProcessor != null) {
                    providerProcessor.process((Object)provider);
                }
                indentOptions.setFileIndentOptionsProvider(provider);
                CodeStyleSettings.logIndentOptions(file, provider, indentOptions);
                return indentOptions;
            }
            Language language = LanguageUtil.getLanguageForPsi(file.getProject(), file.getVirtualFile());
            if (language != null && (options = this.getIndentOptions(language)) != null) {
                return options;
            }
            return this.getIndentOptions(file.getFileType());
        }
        return this.OTHER_INDENT_OPTIONS;
    }

    private static boolean isFileFullyCoveredByRange(@NotNull PsiFile file, @Nullable TextRange formatRange) {
        return formatRange != null && formatRange.equals((Object)file.getTextRange());
    }

    private static void logIndentOptions(@NotNull PsiFile file, @NotNull FileIndentOptionsProvider provider, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        LOG.debug("Indent options returned by " + provider.getClass().getName() + " for " + file.getName() + ": indent size=" + options.INDENT_SIZE + ", use tabs=" + options.USE_TAB_CHARACTER + ", tab size=" + options.TAB_SIZE);
    }

    @Nullable
    private CommonCodeStyleSettings.IndentOptions getLanguageIndentOptions(@Nullable FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        Language lang = ((LanguageFileType)fileType).getLanguage();
        return this.getIndentOptions(lang);
    }

    public CommonCodeStyleSettings.IndentOptions getLanguageIndentOptions(@NotNull Language language) {
        CommonCodeStyleSettings.IndentOptions langOptions = this.getIndentOptions(language);
        return langOptions != null ? langOptions : this.OTHER_INDENT_OPTIONS;
    }

    @Nullable
    private CommonCodeStyleSettings.IndentOptions getIndentOptions(Language lang) {
        CommonCodeStyleSettings settings = this.myCommonSettingsManager.getCommonSettings(lang);
        return settings != null ? settings.getIndentOptions() : null;
    }

    public boolean isSmartTabs(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).SMART_TABS;
    }

    public int getIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).INDENT_SIZE;
    }

    public int getContinuationIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).CONTINUATION_INDENT_SIZE;
    }

    public int getTabSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).TAB_SIZE;
    }

    public boolean useTabCharacter(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).USE_TAB_CHARACTER;
    }

    private void registerAdditionalIndentOptions(FileType fileType, CommonCodeStyleSettings.IndentOptions options) {
        boolean exist = false;
        for (FileType existing : this.myAdditionalIndentOptions.keySet()) {
            if (!Comparing.strEqual((String)existing.getDefaultExtension(), (String)fileType.getDefaultExtension())) continue;
            exist = true;
            break;
        }
        if (!exist) {
            this.myAdditionalIndentOptions.put(fileType, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAdditionalIndentOptions() {
        Map<FileType, CommonCodeStyleSettings.IndentOptions> map = this.myAdditionalIndentOptions;
        synchronized (map) {
            this.myLoadedAdditionalIndentOptions = true;
            for (FileTypeIndentOptionsProvider provider : FileTypeIndentOptionsProvider.EP_NAME.getExtensionList()) {
                if (this.myAdditionalIndentOptions.containsKey(provider.getFileType())) continue;
                this.registerAdditionalIndentOptions(provider.getFileType(), CodeStyleSettings.getFileTypeIndentOptions(provider));
            }
        }
    }

    private static CommonCodeStyleSettings.IndentOptions getFileTypeIndentOptions(FileTypeIndentOptionsProvider provider) {
        try {
            return provider.createIndentOptions();
        }
        catch (AbstractMethodError error) {
            LOG.error("Plugin uses obsolete API.", (Throwable)new ExtensionException(provider.getClass()));
            return new CommonCodeStyleSettings.IndentOptions();
        }
    }

    public void clearCodeStyleSettings() {
        this.clearCodeStyleSettings(new CodeStyleSettings());
    }

    public void clearCodeStyleSettings(CodeStyleSettings oldCodeStyleSettings) {
        this.copyFrom(oldCodeStyleSettings);
        this.myAdditionalIndentOptions.clear();
        this.myLoadedAdditionalIndentOptions = false;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings(@Nullable Language lang) {
        CommonCodeStyleSettings settings = this.myCommonSettingsManager.getCommonSettings(lang);
        if (settings == null) {
            settings = this.myCommonSettingsManager.getDefaults();
        }
        return settings;
    }

    public CommonCodeStyleSettings getCommonSettings(String langName) {
        return this.myCommonSettingsManager.getCommonSettings(langName);
    }

    public int getRightMargin(@Nullable Language language) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null && langSettings.RIGHT_MARGIN >= 0) {
            return langSettings.RIGHT_MARGIN;
        }
        return this.getDefaultRightMargin();
    }

    public void setRightMargin(@Nullable Language language, int rightMargin) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null) {
            langSettings.RIGHT_MARGIN = rightMargin;
            return;
        }
        this.setDefaultRightMargin(rightMargin);
    }

    public int getDefaultRightMargin() {
        return this.RIGHT_MARGIN;
    }

    public void setDefaultRightMargin(int rightMargin) {
        this.RIGHT_MARGIN = rightMargin;
    }

    public boolean isWrapOnTyping(@Nullable Language language) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null && langSettings.WRAP_ON_TYPING != CommonCodeStyleSettings.WrapOnTyping.DEFAULT.intValue) {
            return langSettings.WRAP_ON_TYPING == CommonCodeStyleSettings.WrapOnTyping.WRAP.intValue;
        }
        return this.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CodeStyleSettings)) {
            return false;
        }
        if (!ReflectionUtil.comparePublicNonFinalFields((Object)this, (Object)obj)) {
            return false;
        }
        if (!this.mySoftMargins.equals(((CodeStyleSettings)obj).mySoftMargins)) {
            return false;
        }
        if (!this.myExcludedFiles.equals(((CodeStyleSettings)obj).getExcludedFiles())) {
            return false;
        }
        if (!this.OTHER_INDENT_OPTIONS.equals(((CodeStyleSettings)obj).OTHER_INDENT_OPTIONS)) {
            return false;
        }
        if (!this.myCommonSettingsManager.equals(((CodeStyleSettings)obj).myCommonSettingsManager)) {
            return false;
        }
        for (CustomCodeStyleSettings customSettings : this.myCustomSettings.values()) {
            if (customSettings.equals(((CodeStyleSettings)obj).getCustomSettings(customSettings.getClass()))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static CodeStyleSettings getDefaults() {
        return DefaultsHolder.myDefaults;
    }

    private void migrateLegacySettings() {
        if (this.myVersion < 173) {
            for (CustomCodeStyleSettings settings : this.myCustomSettings.values()) {
                settings.importLegacySettings(this);
            }
            this.myVersion = 173;
        }
    }

    private void notifySettingsBeforeLoading() {
        JBIterable.from((Iterable)this.myCustomSettings.values()).forEach(CustomCodeStyleSettings::beforeLoading);
    }

    private void notifySettingsLoaded() {
        JBIterable.from((Iterable)this.myCustomSettings.values()).forEach(CustomCodeStyleSettings::afterLoaded);
    }

    public void resetDeprecatedFields() {
        CodeStyleSettings defaults = CodeStyleSettings.getDefaults();
        ReflectionUtil.copyFields((Field[])this.getClass().getFields(), (Object)defaults, (Object)this, (DifferenceFilter)new DifferenceFilter<CodeStyleSettings>(this, defaults){

            public boolean isAccept(@NotNull Field field) {
                return field.getAnnotation(Deprecated.class) != null;
            }
        });
        this.IMPORT_LAYOUT_TABLE.copyFrom(defaults.IMPORT_LAYOUT_TABLE);
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(defaults.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        this.myRepeatAnnotations.clear();
    }

    public int getVersion() {
        return this.myVersion;
    }

    @NotNull
    public List<Integer> getSoftMargins(@Nullable Language language) {
        CommonCodeStyleSettings languageSettings;
        if (language != null && (languageSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null && !languageSettings.getSoftMargins().isEmpty()) {
            return languageSettings.getSoftMargins();
        }
        return this.getDefaultSoftMargins();
    }

    public void setSoftMargins(@NotNull Language language, List<Integer> softMargins) {
        CommonCodeStyleSettings languageSettings = this.myCommonSettingsManager.getCommonSettings(language);
        assert (languageSettings != null) : "Settings for language " + language.getDisplayName() + " do not exist";
        languageSettings.setSoftMargins(softMargins);
    }

    @NotNull
    public List<Integer> getDefaultSoftMargins() {
        return this.mySoftMargins.getValues();
    }

    public void setDefaultSoftMargins(List<Integer> softMargins) {
        this.mySoftMargins.setValues(softMargins);
    }

    @NotNull
    public ExcludedFiles getExcludedFiles() {
        return this.myExcludedFiles;
    }

    public SimpleModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public static enum QuoteStyle {
        Single("'"),
        Double("\""),
        None("");

        public final String quote;

        private QuoteStyle(String quote) {
            this.quote = quote;
        }
    }

    public static enum HtmlTagNewLineStyle {
        Never("Never"),
        WhenMultiline("When multiline");

        public final String description;

        private HtmlTagNewLineStyle(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    private static class TempFileType
    implements FileType {
        private final String myExtension;

        private TempFileType(@NotNull String extension) {
            this.myExtension = extension;
        }

        @Override
        @NotNull
        public String getName() {
            return "TempFileType";
        }

        @Override
        @NotNull
        public String getDescription() {
            return "TempFileType";
        }

        @Override
        @NotNull
        public String getDefaultExtension() {
            return this.myExtension;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
            return null;
        }
    }

    public static class TypeToNameMap
    implements JDOMExternalizable {
        private final List<String> myPatterns = new ArrayList<String>();
        private final List<String> myNames = new ArrayList<String>();

        public void addPair(String pattern, String name) {
            this.myPatterns.add(pattern);
            this.myNames.add(name);
        }

        public String nameByType(String type) {
            for (int i = 0; i < this.myPatterns.size(); ++i) {
                String pattern = this.myPatterns.get(i);
                if (!(StringUtil.startsWithChar((CharSequence)pattern, (char)'*') ? type.endsWith(pattern.substring(1)) : type.equals(pattern))) continue;
                return this.myNames.get(i);
            }
            return null;
        }

        public void readExternal(@NonNls Element element) throws InvalidDataException {
            this.myPatterns.clear();
            this.myNames.clear();
            for (Object o : element.getChildren("pair")) {
                Element e = (Element)o;
                String pattern = e.getAttributeValue("type");
                String name = e.getAttributeValue("name");
                if (pattern == null || name == null) {
                    throw new InvalidDataException();
                }
                this.myPatterns.add(pattern);
                this.myNames.add(name);
            }
        }

        public void writeExternal(Element parentNode) throws WriteExternalException {
            for (int i = 0; i < this.myPatterns.size(); ++i) {
                String pattern = this.myPatterns.get(i);
                String name = this.myNames.get(i);
                Element element = new Element("pair");
                parentNode.addContent(element);
                element.setAttribute("type", pattern);
                element.setAttribute("name", name);
            }
        }

        public void copyFrom(TypeToNameMap from) {
            assert (from != this);
            this.myPatterns.clear();
            this.myPatterns.addAll(from.myPatterns);
            this.myNames.clear();
            this.myNames.addAll(from.myNames);
        }

        public boolean equals(Object other) {
            if (other instanceof TypeToNameMap) {
                TypeToNameMap otherMap = (TypeToNameMap)other;
                return this.myPatterns.equals(otherMap.myPatterns) && this.myNames.equals(otherMap.myNames);
            }
            return false;
        }

        public int hashCode() {
            int code = 0;
            for (String myPattern : this.myPatterns) {
                code += myPattern.hashCode();
            }
            for (String myName : this.myNames) {
                code += myName.hashCode();
            }
            return code;
        }
    }

    private static class DefaultsHolder {
        private static final CodeStyleSettings myDefaults = new CodeStyleSettings();

        private DefaultsHolder() {
        }
    }
}

