/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettingsManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(CodeStyleSettingsManager.class);
    @Deprecated
    @Nullable
    public volatile CodeStyleSettings PER_PROJECT_SETTINGS;
    public volatile boolean USE_PER_PROJECT_SETTINGS;
    public volatile String PREFERRED_PROJECT_CODE_STYLE;
    private volatile CodeStyleSettings myTemporarySettings;
    private final List<CodeStyleSettingsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public static CodeStyleSettingsManager getInstance(@Nullable Project project) {
        if (project == null || project.isDefault()) {
            return CodeStyleSettingsManager.getInstance();
        }
        ProjectCodeStyleSettingsManager projectSettingsManager = ServiceManager.getService(project, ProjectCodeStyleSettingsManager.class);
        projectSettingsManager.initProjectSettings(project);
        return projectSettingsManager;
    }

    @Deprecated
    public static CodeStyleSettingsManager getInstance() {
        return ServiceManager.getService(AppCodeStyleSettingsManager.class);
    }

    @Deprecated
    @NotNull
    public static CodeStyleSettings getSettings(@Nullable Project project) {
        return CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
    }

    @Deprecated
    @NotNull
    public CodeStyleSettings getCurrentSettings() {
        CodeStyleSettings temporarySettings = this.myTemporarySettings;
        if (temporarySettings != null) {
            return temporarySettings;
        }
        CodeStyleSettings projectSettings = this.getMainProjectCodeStyle();
        if (this.USE_PER_PROJECT_SETTINGS && projectSettings != null) {
            return projectSettings;
        }
        return CodeStyleSchemes.getInstance().findPreferredScheme(this.PREFERRED_PROJECT_CODE_STYLE).getCodeStyleSettings();
    }

    @Override
    public Element getState() {
        Element result2 = new Element("state");
        try {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)result2, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter<CodeStyleSettingsManager>(this, new CodeStyleSettingsManager()){

                public boolean isAccept(@NotNull Field field) {
                    return !CodeStyleSettingsManager.this.isIgnoredOnSave(field.getName()) && super.isAccept(field);
                }
            });
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return result2;
    }

    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        return false;
    }

    @Override
    public void loadState(@NotNull Element state) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        this.PER_PROJECT_SETTINGS = settings;
    }

    @Nullable
    public CodeStyleSettings getMainProjectCodeStyle() {
        return this.PER_PROJECT_SETTINGS;
    }

    @Deprecated
    public boolean isLoaded() {
        return true;
    }

    public void setTemporarySettings(@NotNull CodeStyleSettings settings) {
        this.updateSettingsTracker();
        this.myTemporarySettings = settings;
    }

    public void dropTemporarySettings() {
        this.updateSettingsTracker();
        this.myTemporarySettings = null;
    }

    @Nullable
    public CodeStyleSettings getTemporarySettings() {
        return this.myTemporarySettings;
    }

    public void addListener(@NotNull CodeStyleSettingsListener listener) {
        this.myListeners.add(listener);
    }

    private void removeListener(@NotNull CodeStyleSettingsListener listener) {
        this.myListeners.remove(listener);
    }

    public static void removeListener(@Nullable Project project, @NotNull CodeStyleSettingsListener listener) {
        CodeStyleSettingsManager projectInstance;
        if (project == null || project.isDefault()) {
            CodeStyleSettingsManager.getInstance().removeListener(listener);
        } else if (!project.isDisposed() && (projectInstance = (CodeStyleSettingsManager)ServiceManager.getService(project, ProjectCodeStyleSettingsManager.class)) != null) {
            projectInstance.removeListener(listener);
        }
    }

    public void fireCodeStyleSettingsChanged(@Nullable PsiFile file) {
        for (CodeStyleSettingsListener listener : this.myListeners) {
            listener.codeStyleSettingsChanged(new CodeStyleSettingsChangeEvent(file));
        }
    }

    public final void notifyCodeStyleSettingsChanged() {
        this.updateSettingsTracker();
        this.fireCodeStyleSettingsChanged(null);
    }

    private void updateSettingsTracker() {
        CodeStyleSettings settings = this.getCurrentSettings();
        settings.getModificationTracker().incModificationCount();
    }
}

