/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CommonCodeStyleSettingsManager {
    private volatile Map<Language, CommonCodeStyleSettings> myCommonSettingsMap;
    private volatile Map<String, Content> myUnknownSettingsMap;
    @NotNull
    private final CodeStyleSettings myParentSettings;
    @NonNls
    static final String COMMON_SETTINGS_TAG = "codeStyleSettings";
    private static final String LANGUAGE_ATTR = "language";
    private static final Logger LOG = Logger.getInstance(CommonCodeStyleSettingsManager.class);

    CommonCodeStyleSettingsManager(@NotNull CodeStyleSettings parentSettings) {
        this.myParentSettings = parentSettings;
    }

    @Nullable
    CommonCodeStyleSettings getCommonSettings(@Nullable Language lang) {
        Map<Language, CommonCodeStyleSettings> commonSettingsMap = this.getCommonSettingsMap();
        for (Language baseLang = (Language)((Object)ObjectUtils.notNull((Object)((Object)lang), (Object)((Object)Language.ANY))); baseLang != null; baseLang = baseLang.getBaseLanguage()) {
            CommonCodeStyleSettings settings = commonSettingsMap.get((Object)baseLang);
            if (settings == null) continue;
            return settings;
        }
        return null;
    }

    CommonCodeStyleSettings getDefaults() {
        return DefaultsHolder.SETTINGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Language, CommonCodeStyleSettings> getCommonSettingsMap() {
        Map<Language, CommonCodeStyleSettings> commonSettingsMap = this.myCommonSettingsMap;
        if (commonSettingsMap == null) {
            CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
            synchronized (commonCodeStyleSettingsManager) {
                commonSettingsMap = this.myCommonSettingsMap;
                if (commonSettingsMap == null) {
                    commonSettingsMap = this.initCommonSettingsMap();
                    this.initNonReadSettings();
                }
            }
        }
        return commonSettingsMap;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings(@NotNull String langName) {
        Map<Language, CommonCodeStyleSettings> map = this.getCommonSettingsMap();
        for (Map.Entry<Language, CommonCodeStyleSettings> entry : map.entrySet()) {
            if (!langName.equals(entry.getKey().getDisplayName())) continue;
            return entry.getValue();
        }
        return new CommonCodeStyleSettings(Language.ANY);
    }

    private void initNonReadSettings() {
        for (LanguageCodeStyleSettingsProvider provider : LanguageCodeStyleSettingsProvider.EP_NAME.getExtensionList()) {
            CommonCodeStyleSettings initialSettings;
            Language target = provider.getLanguage();
            if (this.myCommonSettingsMap.containsKey((Object)target) || (initialSettings = CommonCodeStyleSettingsManager.safelyGetDefaults(provider)) == null) continue;
            this.init(initialSettings, target);
        }
    }

    private void init(@NotNull CommonCodeStyleSettings initialSettings, @NotNull Language target) {
        initialSettings.setRootSettings(this.myParentSettings);
        this.registerCommonSettings(target, initialSettings);
    }

    private Map<Language, CommonCodeStyleSettings> initCommonSettingsMap() {
        LinkedHashMap<Language, CommonCodeStyleSettings> map = new LinkedHashMap<Language, CommonCodeStyleSettings>();
        this.myCommonSettingsMap = map;
        this.myUnknownSettingsMap = new LinkedHashMap<String, Content>();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCommonSettings(@NotNull Language lang, @NotNull CommonCodeStyleSettings settings) {
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (!this.myCommonSettingsMap.containsKey((Object)lang)) {
                this.myCommonSettingsMap.put(lang, settings);
                settings.getRootSettings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CommonCodeStyleSettingsManager clone(@NotNull CodeStyleSettings parentSettings) {
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            CommonCodeStyleSettingsManager settingsManager = new CommonCodeStyleSettingsManager(parentSettings);
            if (this.myCommonSettingsMap != null && !this.myCommonSettingsMap.isEmpty()) {
                settingsManager.initCommonSettingsMap();
                for (Map.Entry<Language, CommonCodeStyleSettings> entry : this.myCommonSettingsMap.entrySet()) {
                    CommonCodeStyleSettings clonedSettings = entry.getValue().clone(parentSettings);
                    settingsManager.registerCommonSettings(entry.getKey(), clonedSettings);
                }
                settingsManager.myUnknownSettingsMap.putAll(this.myUnknownSettingsMap);
            }
            return settingsManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            this.initCommonSettingsMap();
            for (Element commonSettingsElement : element.getChildren(COMMON_SETTINGS_TAG)) {
                boolean isKnownLanguage;
                String languageId = commonSettingsElement.getAttributeValue(LANGUAGE_ATTR);
                if (StringUtil.isEmpty((String)languageId)) continue;
                Language target = Language.findLanguageByID(languageId);
                boolean bl = isKnownLanguage = target != null;
                if (isKnownLanguage) {
                    LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(target);
                    if (provider != null) {
                        CommonCodeStyleSettings settings = CommonCodeStyleSettingsManager.safelyGetDefaults(provider);
                        if (settings != null) {
                            settings.readExternal(commonSettingsElement);
                            this.init(settings, target);
                        }
                    } else {
                        isKnownLanguage = false;
                    }
                }
                if (isKnownLanguage) continue;
                this.myUnknownSettingsMap.put(languageId, (Content)JDOMUtil.internElement((Element)commonSettingsElement));
            }
            this.initNonReadSettings();
        }
    }

    private static CommonCodeStyleSettings safelyGetDefaults(LanguageCodeStyleSettingsProvider provider) {
        Ref defaultSettingsRef = (Ref)RecursionManager.doPreventingRecursion((Object)provider, (boolean)true, () -> Ref.create((Object)provider.getDefaultCommonSettings()));
        if (defaultSettingsRef == null) {
            LOG.error((Throwable)new ExtensionException(provider.getClass(), new Throwable(provider.getClass().getCanonicalName() + ".getDefaultCommonSettings() recursively creates root settings.")));
            return null;
        }
        CommonCodeStyleSettings defaultSettings = (CommonCodeStyleSettings)defaultSettingsRef.get();
        if (defaultSettings instanceof CodeStyleSettings) {
            LOG.error((Throwable)new ExtensionException(provider.getClass(), new Throwable(provider.getClass().getName() + ".getDefaultCommonSettings() creates root CodeStyleSettings instead of CommonCodeStyleSettings")));
        }
        return defaultSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (this.myCommonSettingsMap == null) {
                return;
            }
            THashMap idToLang = new THashMap();
            for (Language language : this.myCommonSettingsMap.keySet()) {
                idToLang.put(language.getID(), language);
            }
            Object[] languages = ArrayUtil.toStringArray((Collection)ContainerUtil.union(this.myUnknownSettingsMap.keySet(), idToLang.keySet()));
            Arrays.sort(languages);
            for (Object id : languages) {
                Language language = (Language)((Object)idToLang.get(id));
                if (language != null) {
                    CommonCodeStyleSettings commonSettings = this.myCommonSettingsMap.get((Object)language);
                    Element commonSettingsElement = new Element(COMMON_SETTINGS_TAG);
                    commonSettings.writeExternal(commonSettingsElement);
                    commonSettingsElement.setAttribute(LANGUAGE_ATTR, language.getID());
                    if (commonSettingsElement.getChildren().isEmpty()) continue;
                    element.addContent(commonSettingsElement);
                    continue;
                }
                Content unknown = this.myUnknownSettingsMap.get(id);
                if (unknown == null) continue;
                element.addContent(unknown.clone());
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommonCodeStyleSettingsManager) {
            CommonCodeStyleSettingsManager other = (CommonCodeStyleSettingsManager)obj;
            if (this.getCommonSettingsMap().size() != other.getCommonSettingsMap().size() || this.myUnknownSettingsMap.size() != other.myUnknownSettingsMap.size()) {
                return false;
            }
            for (Language language : this.myCommonSettingsMap.keySet()) {
                CommonCodeStyleSettings otherSettings;
                CommonCodeStyleSettings theseSettings = this.myCommonSettingsMap.get((Object)language);
                if (theseSettings.equals(otherSettings = other.getCommonSettings(language))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class DefaultsHolder {
        private static final CommonCodeStyleSettings SETTINGS = new CommonCodeStyleSettings(Language.ANY);

        private DefaultsHolder() {
        }

        static {
            SETTINGS.initIndentOptions();
            SETTINGS.setRootSettings(CodeStyleSettings.getDefaults());
        }
    }
}

