/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.ReflectionUtil;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CustomCodeStyleSettings
implements Cloneable {
    private CodeStyleSettings myContainer;
    private final String myTagName;

    protected CustomCodeStyleSettings(@NonNls @NotNull String tagName, CodeStyleSettings container) {
        this.myTagName = tagName;
        this.myContainer = container;
    }

    public final CodeStyleSettings getContainer() {
        return this.myContainer;
    }

    void setContainer(CodeStyleSettings container) {
        this.myContainer = container;
    }

    @NonNls
    @NotNull
    public final String getTagName() {
        return this.myTagName;
    }

    @NotNull
    public List<String> getKnownTagNames() {
        return Collections.singletonList(this.getTagName());
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        Element child = parentElement.getChild(this.myTagName);
        if (child != null) {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)child);
        }
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        Element childElement = new Element(this.myTagName);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)childElement, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter((Object)this, (Object)parentSettings));
        if (!childElement.getContent().isEmpty()) {
            parentElement.addContent(childElement);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void importLegacySettings(@NotNull CodeStyleSettings rootSettings) {
    }

    protected void beforeLoading() {
    }

    protected void afterLoaded() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CustomCodeStyleSettings)) {
            return false;
        }
        return ReflectionUtil.comparePublicNonFinalFields((Object)this, (Object)obj);
    }
}

