/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.LanguageCodeStylePropertyMapper;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguageCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    public static final ExtensionPointName<LanguageCodeStyleSettingsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.langCodeStyleSettingsProvider");
    private static final AtomicReference<List<LanguageCodeStyleSettingsProvider>> ourSettingsPagesProviders = new AtomicReference();

    @Nullable
    public abstract String getCodeSample(@NotNull SettingsType var1);

    public int getRightMargin(@NotNull SettingsType settingsType) {
        return settingsType == SettingsType.WRAPPING_AND_BRACES_SETTINGS ? 30 : -1;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull SettingsType settingsType) {
    }

    @Nullable
    public String getFileExt() {
        return null;
    }

    @Nullable
    public String getLanguageName() {
        return null;
    }

    @NotNull
    public String getExternalLanguageId() {
        return this.getLanguage().getID().toLowerCase(Locale.ENGLISH);
    }

    @Nullable
    public PsiFile createFileFromText(Project project, String text) {
        return null;
    }

    @Deprecated
    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings(this.getLanguage());
        defaultSettings.initIndentOptions();
        this.customizeDefaults(defaultSettings, defaultSettings.getIndentOptions());
        return defaultSettings;
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
    }

    @Deprecated
    @NotNull
    public PredefinedCodeStyle[] getPredefinedCodeStyles() {
        return PredefinedCodeStyle.EMPTY_ARRAY;
    }

    public DisplayPriority getDisplayPriority() {
        List<Language> primaryIdeLanguages = IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages();
        return primaryIdeLanguages.contains((Object)this.getLanguage()) ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    public List<Language> getApplicableLanguages() {
        return LanguageCodeStyleSettingsProvider.getLanguagesWithCodeStyleSettings();
    }

    @NotNull
    public static List<Language> getLanguagesWithCodeStyleSettings() {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            languages.add(provider.getLanguage());
        }
        Collections.sort(languages, (l1, l2) -> Comparing.compare((Comparable)((Object)LanguageCodeStyleSettingsProvider.getLanguageName(l1)), (Comparable)((Object)LanguageCodeStyleSettingsProvider.getLanguageName(l2))));
        return languages;
    }

    @Nullable
    public static String getCodeSample(Language lang, @NotNull SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getCodeSample(settingsType) : null;
    }

    public static int getRightMargin(Language lang, @NotNull SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getRightMargin(settingsType) : -1;
    }

    @Override
    @NotNull
    public abstract Language getLanguage();

    @Nullable
    public static Language getLanguage(String langName) {
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            String name = provider.getLanguageName();
            if (name == null) {
                name = provider.getLanguage().getDisplayName();
            }
            if (!langName.equals(name)) continue;
            return provider.getLanguage();
        }
        return null;
    }

    @Nullable
    public static CommonCodeStyleSettings getDefaultCommonSettings(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getDefaultCommonSettings() : null;
    }

    @Nullable
    public static String getFileExt(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getFileExt() : null;
    }

    @NotNull
    public static String getLanguageName(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        String providerLangName = provider != null ? provider.getLanguageName() : null;
        return providerLangName != null ? providerLangName : lang.getDisplayName();
    }

    @Nullable
    public static PsiFile createFileFromText(Language language, Project project, String text) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(language);
        return provider != null ? provider.createFileFromText(project, text) : null;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider forLanguage(Language language) {
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            if (!((Object)((Object)provider.getLanguage())).equals((Object)language)) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider findUsingBaseLanguage(@NotNull Language language) {
        for (Language currLang = language; currLang != null; currLang = currLang.getBaseLanguage()) {
            LanguageCodeStyleSettingsProvider curr = LanguageCodeStyleSettingsProvider.forLanguage(currLang);
            if (curr == null) continue;
            return curr;
        }
        return null;
    }

    public static DisplayPriority getDisplayPriority(Language language) {
        LanguageCodeStyleSettingsProvider langProvider = LanguageCodeStyleSettingsProvider.forLanguage(language);
        if (langProvider == null) {
            return DisplayPriority.LANGUAGE_SETTINGS;
        }
        return langProvider.getDisplayPriority();
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return null;
    }

    public Set<String> getSupportedFields() {
        return new SupportedFieldCollector().collectFields();
    }

    public Set<String> getSupportedFields(SettingsType type) {
        return new SupportedFieldCollector().collectFields(type);
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull CodeStyleSettings rootSettings) {
        return DocCommentSettings.DEFAULTS;
    }

    @Override
    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        throw new RuntimeException(this.getClass().getCanonicalName() + " for language #" + this.getLanguage().getID() + " doesn't implement createConfigurable()");
    }

    public static List<LanguageCodeStyleSettingsProvider> getSettingsPagesProviders() {
        return ourSettingsPagesProviders.updateAndGet(__ -> __ != null ? __ : LanguageCodeStyleSettingsProvider.calcSettingPagesProviders());
    }

    @NotNull
    protected static List<LanguageCodeStyleSettingsProvider> calcSettingPagesProviders() {
        ArrayList settingsPagesProviders = ContainerUtil.newArrayList();
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            try {
                Method configMethod = provider.getClass().getMethod("createConfigurable", CodeStyleSettings.class, CodeStyleSettings.class);
                Class<?> declaringClass = configMethod.getDeclaringClass();
                if (declaringClass.equals(LanguageCodeStyleSettingsProvider.class)) continue;
                settingsPagesProviders.add(provider);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return settingsPagesProviders;
    }

    @ApiStatus.Experimental
    @NotNull
    public final AbstractCodeStylePropertyMapper getPropertyMapper(@NotNull CodeStyleSettings settings) {
        return new LanguageCodeStylePropertyMapper(settings, this.getLanguage(), this.getExternalLanguageId());
    }

    @ApiStatus.Experimental
    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        return null;
    }

    public List<CodeStylePropertyAccessor> getAdditionalAccessors(@NotNull Object codeStyleObject) {
        return Collections.emptyList();
    }

    public boolean supportsExternalFormats() {
        return true;
    }

    private final class SupportedFieldCollector
    implements CodeStyleSettingsCustomizable {
        private final Set<String> myCollectedFields = new THashSet();
        private SettingsType myCurrSettingsType;

        private SupportedFieldCollector() {
        }

        public Set<String> collectFields() {
            SettingsType[] settingsTypeArray = SettingsType.values();
            int n = settingsTypeArray.length;
            for (int i = 0; i < n; ++i) {
                SettingsType settingsType;
                this.myCurrSettingsType = settingsType = settingsTypeArray[i];
                LanguageCodeStyleSettingsProvider.this.customizeSettings(this, settingsType);
            }
            return this.myCollectedFields;
        }

        public Set<String> collectFields(SettingsType type) {
            this.myCurrSettingsType = type;
            LanguageCodeStyleSettingsProvider.this.customizeSettings(this, type);
            return this.myCollectedFields;
        }

        @Override
        public void showAllStandardOptions() {
            switch (this.myCurrSettingsType) {
                case BLANK_LINES_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.BlankLinesOption blankLinesOption : CodeStyleSettingsCustomizable.BlankLinesOption.values()) {
                        this.myCollectedFields.add(blankLinesOption.name());
                    }
                    break;
                }
                case SPACING_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.SpacingOption spacingOption : CodeStyleSettingsCustomizable.SpacingOption.values()) {
                        this.myCollectedFields.add(spacingOption.name());
                    }
                    break;
                }
                case WRAPPING_AND_BRACES_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.WrappingOrBraceOption wrappingOrBraceOption : CodeStyleSettingsCustomizable.WrappingOrBraceOption.values()) {
                        this.myCollectedFields.add(wrappingOrBraceOption.name());
                    }
                    break;
                }
                case COMMENTER_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.CommenterOption commenterOption : CodeStyleSettingsCustomizable.CommenterOption.values()) {
                        this.myCollectedFields.add(commenterOption.name());
                    }
                    break;
                }
            }
        }

        @Override
        public void showStandardOptions(String ... optionNames) {
            ContainerUtil.addAll(this.myCollectedFields, (Object[])optionNames);
        }

        @Override
        public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, @Nullable String groupName, Object ... options) {
            this.myCollectedFields.add(fieldName);
        }

        @Override
        public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @Nullable String anchorFieldName, Object ... options) {
            this.myCollectedFields.add(fieldName);
        }
    }

    public static enum SettingsType {
        BLANK_LINES_SETTINGS,
        SPACING_SETTINGS,
        WRAPPING_AND_BRACES_SETTINGS,
        INDENT_SETTINGS,
        COMMENTER_SETTINGS,
        LANGUAGE_SPECIFIC;

    }
}

