/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LegacyCodeStyleSettingsManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectCodeStyleConfiguration", storages={@Storage(value="codeStyles", stateSplitter=StateSplitter.class)})
public class ProjectCodeStyleSettingsManager
extends CodeStyleSettingsManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + ProjectCodeStyleSettingsManager.class));
    private static final String MAIN_PROJECT_CODE_STYLE_NAME = "Project";
    private static final String PROJECT_CODE_STYLE_CONFIG_FILE_NAME = "codeStyleConfig";
    private volatile boolean myIsLoaded;
    private static final Object LEGACY_SETTINGS_IMPORT_LOCK = new Object();
    private final Map<String, CodeStyleSettings> mySettingsMap = ContainerUtil.newHashMap();
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Code style settings migration", NotificationDisplayType.STICKY_BALLOON, true);

    public ProjectCodeStyleSettingsManager() {
        this.setMainProjectCodeStyle(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initProjectSettings(@NotNull Project project) {
        if (!this.myIsLoaded) {
            Object object = LEGACY_SETTINGS_IMPORT_LOCK;
            synchronized (object) {
                if (!this.myIsLoaded) {
                    LegacyCodeStyleSettingsManager legacySettingsManager = ServiceManager.getService(project, LegacyCodeStyleSettingsManager.class);
                    if (legacySettingsManager != null && legacySettingsManager.getState() != null) {
                        this.loadState(legacySettingsManager.getState());
                        if (!(project.isDefault() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment())) {
                            ProjectCodeStyleSettingsManager.saveProjectAndNotify(project);
                        }
                        LOG.info("Imported old project code style settings.");
                    } else {
                        this.initDefaults();
                        LOG.info("Initialized from default code style settings.");
                    }
                }
            }
        }
    }

    private static void saveProjectAndNotify(@NotNull Project project) {
        TransactionGuard.submitTransaction(project, () -> {
            project.save();
            CodeStyleMigrationNotification notification = new CodeStyleMigrationNotification(project.getName());
            notification.notify(project);
        });
    }

    @Override
    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        this.PER_PROJECT_SETTINGS = settings;
        this.mySettingsMap.put(MAIN_PROJECT_CODE_STYLE_NAME, settings != null ? settings : new CodeStyleSettings());
    }

    @Override
    @NotNull
    public CodeStyleSettings getMainProjectCodeStyle() {
        return this.mySettingsMap.get(MAIN_PROJECT_CODE_STYLE_NAME);
    }

    private void initDefaults() {
        CodeStyleSettingsManager appCodeStyleSettingsManager = CodeStyleSettingsManager.getInstance();
        if (appCodeStyleSettingsManager != null) {
            CodeStyleSettings defaultProjectSettings = appCodeStyleSettingsManager.getMainProjectCodeStyle();
            this.setMainProjectCodeStyle(defaultProjectSettings != null ? defaultProjectSettings.clone() : null);
            this.USE_PER_PROJECT_SETTINGS = appCodeStyleSettingsManager.USE_PER_PROJECT_SETTINGS;
            this.PREFERRED_PROJECT_CODE_STYLE = appCodeStyleSettingsManager.PREFERRED_PROJECT_CODE_STYLE;
        }
        this.myIsLoaded = true;
    }

    @Override
    public void loadState(@NotNull Element state) {
        super.loadState(state);
        this.updateFromOldProjectSettings();
        for (Element subStyle : state.getChildren("code_scheme")) {
            String name = subStyle.getAttributeValue("name");
            CodeStyleSettings settings = new CodeStyleSettings();
            settings.readExternal(subStyle);
            if (MAIN_PROJECT_CODE_STYLE_NAME.equals(name)) {
                this.setMainProjectCodeStyle(settings);
                continue;
            }
            this.mySettingsMap.put(name, settings);
        }
        this.myIsLoaded = true;
    }

    private void updateFromOldProjectSettings() {
        CodeStyleSettings oldProjectSettings = this.PER_PROJECT_SETTINGS;
        if (oldProjectSettings != null) {
            oldProjectSettings.resetDeprecatedFields();
        }
        this.setMainProjectCodeStyle(oldProjectSettings);
    }

    @Override
    public Element getState() {
        Element e = super.getState();
        if (e != null) {
            for (String name : this.mySettingsMap.keySet()) {
                CodeStyleSettings settings = this.mySettingsMap.get(name);
                Element codeStyle = new Element("code_scheme");
                codeStyle.setAttribute("name", name);
                settings.writeExternal(codeStyle);
                if (codeStyle.getContent().isEmpty()) continue;
                e.addContent(codeStyle);
            }
        }
        return e;
    }

    @Override
    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        return "PER_PROJECT_SETTINGS".equals(fieldName);
    }

    static final class StateSplitter
    extends MainConfigurationStateSplitter {
        StateSplitter() {
        }

        @Override
        @NotNull
        protected String getComponentStateFileName() {
            return ProjectCodeStyleSettingsManager.PROJECT_CODE_STYLE_CONFIG_FILE_NAME;
        }

        @Override
        @NotNull
        protected String getSubStateTagName() {
            return "code_scheme";
        }

        @Override
        @NotNull
        protected String getSubStateFileName(@NotNull Element element) {
            return element.getAttributeValue("name");
        }
    }

    private static class ShowMoreInfoAction
    extends DumbAwareAction {
        ShowMoreInfoAction() {
            super("More info");
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            BrowserUtil.open("https://confluence.jetbrains.com/display/IDEADEV/New+project+code+style+settings+format+in+2017.3");
        }
    }

    private static class CodeStyleMigrationNotification
    extends Notification {
        CodeStyleMigrationNotification(@NotNull String projectName) {
            super(NOTIFICATION_GROUP.getDisplayId(), ApplicationBundle.message("project.code.style.migration.title", new Object[0]), ApplicationBundle.message("project.code.style.migration.message", projectName), NotificationType.INFORMATION);
            this.addAction(new ShowMoreInfoAction());
        }
    }
}

