/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.group;

import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import org.jetbrains.annotations.NotNull;

public class ArrangementGroupingRule {
    @NotNull
    private final ArrangementSettingsToken myGroupingType;
    @NotNull
    private final ArrangementSettingsToken myOrderType;

    public ArrangementGroupingRule(@NotNull ArrangementSettingsToken groupingType) {
        this(groupingType, StdArrangementTokens.Order.KEEP);
    }

    public ArrangementGroupingRule(@NotNull ArrangementSettingsToken groupingType, @NotNull ArrangementSettingsToken orderType) {
        this.myGroupingType = groupingType;
        this.myOrderType = orderType;
    }

    @NotNull
    public ArrangementSettingsToken getGroupingType() {
        return this.myGroupingType;
    }

    @NotNull
    public ArrangementSettingsToken getOrderType() {
        return this.myOrderType;
    }

    public ArrangementGroupingRule clone() {
        return new ArrangementGroupingRule(this.myGroupingType, this.myOrderType);
    }

    public int hashCode() {
        int result2 = this.myGroupingType.hashCode();
        result2 = 31 * result2 + this.myOrderType.hashCode();
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementGroupingRule rule = (ArrangementGroupingRule)o;
        if (this.myOrderType != rule.myOrderType) {
            return false;
        }
        return this.myGroupingType.equals(rule.myGroupingType);
    }

    public String toString() {
        return String.format("(%s, %s)", this.myGroupingType, this.myOrderType);
    }
}

