/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ByTypeArrangementEntryMatcher
implements ArrangementEntryMatcher {
    @NotNull
    private final Set<ArrangementAtomMatchCondition> myTypes = ContainerUtilRt.newHashSet();

    public ByTypeArrangementEntryMatcher(@NotNull ArrangementAtomMatchCondition interestedType) {
        this.myTypes.add(interestedType);
    }

    public ByTypeArrangementEntryMatcher(@NotNull Collection<? extends ArrangementAtomMatchCondition> interestedTypes) {
        this.myTypes.addAll(interestedTypes);
    }

    @Override
    public boolean isMatched(@NotNull ArrangementEntry entry) {
        if (entry instanceof TypeAwareArrangementEntry) {
            Set<ArrangementSettingsToken> types = ((TypeAwareArrangementEntry)entry).getTypes();
            for (ArrangementAtomMatchCondition condition : this.myTypes) {
                Object value = condition.getValue();
                boolean isInverted = value instanceof Boolean && (Boolean)value == false;
                if (isInverted != types.contains(condition.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public Set<ArrangementAtomMatchCondition> getTypes() {
        return this.myTypes;
    }

    public int hashCode() {
        return this.myTypes.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByTypeArrangementEntryMatcher that = (ByTypeArrangementEntryMatcher)o;
        return this.myTypes.equals(that.myTypes);
    }

    public String toString() {
        return String.format("of type '%s'", this.myTypes);
    }
}

