/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.psi.codeStyle.arrangement.ArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StdArrangementExtendableSettings
extends StdArrangementSettings
implements ArrangementExtendableSettings {
    @NotNull
    private final Set<StdArrangementRuleAliasToken> myRulesAliases = new THashSet();
    @NotNull
    private final List<ArrangementSectionRule> myExtendedSectionRules = Collections.synchronizedList(new ArrayList());

    public StdArrangementExtendableSettings() {
    }

    public StdArrangementExtendableSettings(@NotNull List<? extends ArrangementGroupingRule> groupingRules, @NotNull List<? extends ArrangementSectionRule> sectionRules, @NotNull Collection<? extends StdArrangementRuleAliasToken> rulesAliases) {
        super(groupingRules, sectionRules);
        this.myRulesAliases.addAll(rulesAliases);
    }

    public static StdArrangementExtendableSettings createByMatchRules(@NotNull List<? extends ArrangementGroupingRule> groupingRules, @NotNull List<? extends StdArrangementMatchRule> matchRules, @NotNull Collection<? extends StdArrangementRuleAliasToken> rulesAliases) {
        ArrayList<ArrangementSectionRule> sectionRules = new ArrayList<ArrangementSectionRule>();
        for (StdArrangementMatchRule stdArrangementMatchRule : matchRules) {
            sectionRules.add(ArrangementSectionRule.create(stdArrangementMatchRule));
        }
        return new StdArrangementExtendableSettings(groupingRules, sectionRules, rulesAliases);
    }

    @Override
    public Set<StdArrangementRuleAliasToken> getRuleAliases() {
        return this.myRulesAliases;
    }

    private Set<StdArrangementRuleAliasToken> cloneTokenDefinitions() {
        THashSet definitions = new THashSet();
        for (StdArrangementRuleAliasToken definition : this.myRulesAliases) {
            definitions.add(definition.clone());
        }
        return definitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArrangementSectionRule> getExtendedSectionRules() {
        List<ArrangementSectionRule> list = this.myExtendedSectionRules;
        synchronized (list) {
            if (this.myExtendedSectionRules.isEmpty()) {
                THashMap tokenIdToDefinition = new THashMap(this.myRulesAliases.size());
                for (StdArrangementRuleAliasToken alias : this.myRulesAliases) {
                    String id = alias.getId();
                    tokenIdToDefinition.put(id, alias);
                }
                List<ArrangementSectionRule> sections = this.getSections();
                for (ArrangementSectionRule section : sections) {
                    ArrayList extendedRules = new ArrayList();
                    for (StdArrangementMatchRule rule : section.getMatchRules()) {
                        this.appendExpandedRules(rule, extendedRules, (Map<String, StdArrangementRuleAliasToken>)tokenIdToDefinition);
                    }
                    this.myExtendedSectionRules.add(ArrangementSectionRule.create(section.getStartComment(), section.getEndComment(), extendedRules));
                }
            }
        }
        return this.myExtendedSectionRules;
    }

    public void appendExpandedRules(@NotNull StdArrangementMatchRule rule, @NotNull List<? super StdArrangementMatchRule> rules, @NotNull Map<String, StdArrangementRuleAliasToken> tokenIdToDefinition) {
        List<StdArrangementMatchRule> sequence = this.getRuleSequence(rule, tokenIdToDefinition);
        if (sequence.isEmpty()) {
            rules.add(rule);
            return;
        }
        ArrangementCompositeMatchCondition ruleTemplate = StdArrangementExtendableSettings.removeAliasRuleToken(rule.getMatcher().getCondition());
        for (StdArrangementMatchRule matchRule : sequence) {
            ArrangementCompositeMatchCondition extendedRule = ruleTemplate.clone();
            extendedRule.addOperand(matchRule.getMatcher().getCondition());
            rules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher(extendedRule)));
        }
    }

    @NotNull
    private List<StdArrangementMatchRule> getRuleSequence(@NotNull StdArrangementMatchRule rule, final @NotNull Map<String, StdArrangementRuleAliasToken> tokenIdToDefinition) {
        final List seqRule = ContainerUtil.newSmartList();
        rule.getMatcher().getCondition().invite(new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                StdArrangementRuleAliasToken token = (StdArrangementRuleAliasToken)tokenIdToDefinition.get(condition.getType().getId());
                if (token != null && !token.getDefinitionRules().isEmpty()) {
                    seqRule.addAll(token.getDefinitionRules());
                }
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                for (ArrangementMatchCondition operand : condition.getOperands()) {
                    if (!seqRule.isEmpty()) {
                        return;
                    }
                    operand.invite(this);
                }
            }
        });
        return seqRule;
    }

    @NotNull
    private static ArrangementCompositeMatchCondition removeAliasRuleToken(ArrangementMatchCondition original) {
        final ArrangementCompositeMatchCondition composite = new ArrangementCompositeMatchCondition();
        original.invite(new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                if (!ArrangementUtil.isAliasedCondition(condition)) {
                    composite.addOperand(condition);
                }
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite(this);
                }
            }
        });
        return composite;
    }

    @Override
    public void addRule(@NotNull StdArrangementMatchRule rule) {
        this.addSectionRule(rule);
        this.myRulesByPriority.clear();
        this.myExtendedSectionRules.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<? extends ArrangementMatchRule> getRulesSortedByPriority() {
        List<ArrangementSectionRule> list = this.myExtendedSectionRules;
        synchronized (list) {
            if (this.myRulesByPriority.isEmpty()) {
                for (ArrangementSectionRule rule : this.getExtendedSectionRules()) {
                    this.myRulesByPriority.addAll(rule.getMatchRules());
                }
                ContainerUtil.sort((List)this.myRulesByPriority);
            }
        }
        return this.myRulesByPriority;
    }

    @Override
    @NotNull
    public StdArrangementExtendableSettings clone() {
        return new StdArrangementExtendableSettings(this.cloneGroupings(), this.cloneSectionRules(), this.cloneTokenDefinitions());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementExtendableSettings settings = (StdArrangementExtendableSettings)o;
        if (!super.equals(settings)) {
            return false;
        }
        return this.myRulesAliases.equals(settings.myRulesAliases);
    }
}

