/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.processor;

import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.values.ClassSerializer;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CodeStyleDeriveProcessor {
    protected final LangCodeStyleExtractor myLangExtractor;

    protected CodeStyleDeriveProcessor(@NotNull LangCodeStyleExtractor langExtractor) {
        this.myLangExtractor = langExtractor;
    }

    public abstract ValuesExtractionResult runWithProgress(Project var1, CodeStyleSettings var2, PsiFile var3, ProgressIndicator var4);

    @NotNull
    public Map<Value, Object> backupValues(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        List<Value> baseValues = this.getFormattingValues(settings, language);
        HashMap res = ContainerUtil.newHashMap();
        for (Value baseValue : baseValues) {
            res.put(baseValue, baseValue.value);
        }
        return res;
    }

    @NotNull
    private Collection<Value.VAR_KIND> getVarKinds() {
        LinkedList<Value.VAR_KIND> varKinds = new LinkedList<Value.VAR_KIND>();
        varKinds.addAll(this.myLangExtractor.getCustomVarKinds());
        varKinds.addAll(Arrays.asList(Value.VAR_KIND.defaultKinds));
        return varKinds;
    }

    @NotNull
    private Value.VAR_KIND getVarKind(@NotNull String name, @NotNull Object value) {
        for (Value.VAR_KIND varKind : this.getVarKinds()) {
            if (!varKind.accepts(name, value)) continue;
            return varKind;
        }
        return Value.VAR_KIND.NOTHING;
    }

    @NotNull
    private List<Value> readAll(@NotNull String instanceName, @NotNull Object instance) {
        Class<?> cls = instance.getClass();
        ArrayList<Value> ret = new ArrayList<Value>();
        ClassSerializer serializer2 = new ClassSerializer(instanceName, instance);
        for (Field field : cls.getDeclaredFields()) {
            if ((field = ClassSerializer.getPreparedField(field)) == null || field.getName().endsWith("_FORCE")) continue;
            try {
                ret.add(this.buildFValue(field, instance, serializer2));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @NotNull
    private Value buildFValue(@NotNull Field field, @NotNull Object instance, @NotNull ClassSerializer serializer2) throws IllegalAccessException {
        String name = field.getName();
        Object value = field.get(instance);
        Value.VAR_KIND varKind = this.getVarKind(name, value);
        return new Value(name, value, serializer2, varKind);
    }

    @NotNull
    protected List<Value> getFormattingValues(CodeStyleSettings settings, Language language) {
        LanguageCodeStyleSettingsProvider provider;
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(language);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        if (indentOptions == null) {
            Utils.logError("IndentOptions from common settings are null; using indent options from settings.");
            indentOptions = settings.getIndentOptions();
        }
        CustomCodeStyleSettings languageSettings = Utils.getLanguageSettings(settings, language);
        List<Value> values = this.readAll("commonSettings", commonSettings);
        if (languageSettings != null) {
            values.addAll(this.readAll("languageSettings", languageSettings));
        }
        if ((provider = LanguageCodeStyleSettingsProvider.forLanguage(language)) != null) {
            Set<String> supportedFields = provider.getSupportedFields();
            ArrayList<Value> cvalues = new ArrayList<Value>(values.size());
            for (Value value : values) {
                if (!supportedFields.contains(value.name)) continue;
                cvalues.add(value);
            }
            values = cvalues;
        }
        if (indentOptions != null) {
            List<Value> valuesOrder = this.readAll("indentOptions", indentOptions);
            valuesOrder.addAll(values);
            return valuesOrder;
        }
        Utils.logError("Indent options were not detected.");
        return values;
    }

    @NotNull
    public abstract String getHTMLReport();
}

