/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.modifier;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransientCodeStyleSettings
extends CodeStyleSettings {
    private final PsiFile myPsiFile;
    private CodeStyleSettingsModifier myModifier;
    private final List<Object> myDependencies = ContainerUtil.newArrayList();

    public TransientCodeStyleSettings(@NotNull PsiFile psiFile, @NotNull CodeStyleSettings settings) {
        this.myPsiFile = psiFile;
        this.copyFrom(settings);
        this.myDependencies.add(settings.getModificationTracker());
    }

    public void setModifier(@NotNull CodeStyleSettingsModifier modifier) {
        this.myModifier = modifier;
    }

    @Nullable
    public CodeStyleSettingsModifier getModifier() {
        return this.myModifier;
    }

    @NotNull
    public PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    @Override
    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@Nullable PsiFile file, @Nullable TextRange formatRange, boolean ignoreDocOptions, @Nullable Processor<? super FileIndentOptionsProvider> providerProcessor) {
        if (file != null && file.isValid()) {
            FileType fileType = file.getFileType();
            return this.getIndentOptions(fileType);
        }
        return this.OTHER_INDENT_OPTIONS;
    }

    public void addDependency(@NotNull ModificationTracker dependency) {
        this.myDependencies.add(dependency);
    }

    public void addDependencies(@NotNull List<? extends ModificationTracker> dependencies) {
        this.myDependencies.addAll(dependencies);
    }

    public List<Object> getDependencies() {
        return this.myDependencies;
    }
}

