/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectAwareFileFilter;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GlobalSearchScope
extends SearchScope
implements ProjectAwareFileFilter {
    public static final GlobalSearchScope[] EMPTY_ARRAY = new GlobalSearchScope[0];
    @Nullable
    private final Project myProject;
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    protected GlobalSearchScope(@Nullable Project project) {
        this.myProject = project;
    }

    protected GlobalSearchScope() {
        this(null);
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        return 0;
    }

    public abstract boolean isSearchInModuleContent(@NotNull Module var1);

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        return this.isSearchInModuleContent(aModule);
    }

    @Override
    public final boolean accept(VirtualFile file) {
        return this.contains(file);
    }

    public abstract boolean isSearchInLibraries();

    public boolean isForceSearchingInLibrarySources() {
        return false;
    }

    public boolean isSearchOutsideRootModel() {
        return false;
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        return Collections.emptySet();
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == this) {
            return this;
        }
        if (scope instanceof IntersectionScope && ((IntersectionScope)scope).containsScope(this)) {
            return scope;
        }
        return new IntersectionScope(this, scope, null);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localScope2 = (LocalSearchScope)scope2;
            return this.intersectWith(localScope2);
        }
        return this.intersectWith((GlobalSearchScope)scope2);
    }

    @NotNull
    @Contract(pure=true)
    public SearchScope intersectWith(@NotNull LocalSearchScope localScope2) {
        PsiElement[] elements2 = localScope2.getScope();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elements2.length);
        for (PsiElement element2 : elements2) {
            if (!PsiSearchScopeUtil.isInScope(this, element2)) continue;
            result2.add(element2);
        }
        return result2.isEmpty() ? EMPTY_SCOPE : new LocalSearchScope(result2.toArray(PsiElement.EMPTY_ARRAY), null, localScope2.isIgnoreInjectedPsi());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope union(@NotNull SearchScope scope) {
        if (scope instanceof GlobalSearchScope) {
            return this.uniteWith((GlobalSearchScope)scope);
        }
        return this.union((LocalSearchScope)scope);
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope union(final @NotNull LocalSearchScope scope) {
        PsiElement[] localScopeElements = scope.getScope();
        if (localScopeElements.length == 0) {
            return this;
        }
        return new GlobalSearchScope(localScopeElements[0].getProject()){

            @Override
            public boolean contains(@NotNull VirtualFile file) {
                return GlobalSearchScope.this.contains(file) || scope.isInScope(file);
            }

            @Override
            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                return GlobalSearchScope.this.contains(file1) && GlobalSearchScope.this.contains(file2) ? GlobalSearchScope.this.compare(file1, file2) : 0;
            }

            @Override
            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                return GlobalSearchScope.this.isSearchInModuleContent(aModule);
            }

            @Override
            public boolean isSearchOutsideRootModel() {
                return GlobalSearchScope.this.isSearchOutsideRootModel();
            }

            @Override
            public boolean isSearchInLibraries() {
                return GlobalSearchScope.this.isSearchInLibraries();
            }

            @Override
            @NotNull
            public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
                return GlobalSearchScope.this.getUnloadedModulesBelongingToScope();
            }

            @NonNls
            public String toString() {
                return "UnionToLocal: (" + GlobalSearchScope.this + ", " + scope + ")";
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        return UnionScope.create(new GlobalSearchScope[]{this, scope});
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope union(@NotNull Collection<? extends GlobalSearchScope> scopes) {
        if (scopes.isEmpty()) {
            throw new IllegalArgumentException("Empty scope collection");
        }
        if (scopes.size() == 1) {
            return scopes.iterator().next();
        }
        return UnionScope.create(scopes.toArray(EMPTY_ARRAY));
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope union(@NotNull GlobalSearchScope[] scopes) {
        if (scopes.length == 0) {
            throw new IllegalArgumentException("Empty scope array");
        }
        if (scopes.length == 1) {
            return scopes[0];
        }
        return UnionScope.create(scopes);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope allScope(@NotNull Project project) {
        return ProjectScope.getAllScope(project);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope projectScope(@NotNull Project project) {
        return ProjectScope.getProjectScope(project);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope everythingScope(@NotNull Project project) {
        return ProjectScope.getEverythingScope(project);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope notScope(@NotNull GlobalSearchScope scope) {
        return new NotScope(scope);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleScope(@NotNull Module module) {
        return module.getModuleScope();
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithLibrariesScope(@NotNull Module module) {
        return module.getModuleWithLibrariesScope();
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesScope(@NotNull Module module) {
        return module.getModuleWithDependenciesScope();
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleRuntimeScope(@NotNull Module module, boolean includeTests) {
        return module.getModuleRuntimeScope(includeTests);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module) {
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, true);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module, boolean includeTests) {
        return module.getModuleWithDependenciesAndLibrariesScope(includeTests);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependentsScope(@NotNull Module module) {
        return module.getModuleWithDependentsScope();
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleTestsWithDependentsScope(@NotNull Module module) {
        return module.getModuleTestsWithDependentsScope();
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull PsiFile psiFile) {
        return new FileScope(psiFile.getProject(), psiFile.getVirtualFile(), null);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull Project project, VirtualFile virtualFile2) {
        return GlobalSearchScope.fileScope(project, virtualFile2, null);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull Project project, @Nullable VirtualFile virtualFile2, @Nullable String displayName) {
        return new FileScope(project, virtualFile2, displayName);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files) {
        return GlobalSearchScope.filesScope(project, files, null);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesWithoutLibrariesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files) {
        if (files.isEmpty()) {
            return EMPTY_SCOPE;
        }
        return new FilesScope(project, files, false, false);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesWithLibrariesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files) {
        return GlobalSearchScope.filesWithLibrariesScope(project, files, false);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesWithLibrariesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files, boolean searchOutsideRootModel) {
        if (files.isEmpty()) {
            return EMPTY_SCOPE;
        }
        return new FilesScope(project, files, true, searchOutsideRootModel);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files, final @Nullable String displayName) {
        if (files.isEmpty()) {
            return EMPTY_SCOPE;
        }
        return files.size() == 1 ? GlobalSearchScope.fileScope(project, files.iterator().next(), displayName) : new FilesScope(project, files){

            @Override
            @NotNull
            public String getDisplayName() {
                return displayName == null ? super.getDisplayName() : displayName;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope getScopeRestrictedByFileTypes(@NotNull GlobalSearchScope scope, FileType ... fileTypes) {
        if (scope == EMPTY_SCOPE) {
            return EMPTY_SCOPE;
        }
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        return new FileTypeRestrictionScope(scope, fileTypes);
    }

    public static class FilesScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final Set<? extends VirtualFile> myFiles;
        private final boolean mySearchOutsideRootModel;
        private volatile Boolean myHasFilesOutOfProjectRoots;

        private FilesScope(@Nullable Project project, @NotNull Collection<? extends VirtualFile> files) {
            this(project, files, null, false);
        }

        private FilesScope(@Nullable Project project, @NotNull Collection<? extends VirtualFile> files, @Nullable Boolean hasFilesOutOfProjectRoots, boolean searchOutsideRootModel) {
            super(project);
            this.myFiles = new CompactVirtualFileSet(files);
            ((CompactVirtualFileSet)this.myFiles).freeze();
            this.mySearchOutsideRootModel = searchOutsideRootModel;
            this.myHasFilesOutOfProjectRoots = hasFilesOutOfProjectRoots;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            return this.myFiles.contains(file);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.hasFilesOutOfProjectRoots();
        }

        public boolean equals(Object o) {
            return this == o || o instanceof FilesScope && this.myFiles.equals(((FilesScope)o).myFiles);
        }

        @Override
        public int calcHashCode() {
            return this.myFiles.hashCode();
        }

        private boolean hasFilesOutOfProjectRoots() {
            Boolean result2 = this.myHasFilesOutOfProjectRoots;
            if (result2 == null) {
                Project project = this.getProject();
                this.myHasFilesOutOfProjectRoots = result2 = Boolean.valueOf(project != null && !project.isDefault() && ContainerUtil.find(this.myFiles, file -> FileIndexFacade.getInstance(project).getModuleForFile((VirtualFile)file) != null) == null);
            }
            return result2;
        }

        public String toString() {
            List files = ContainerUtil.getFirstItems(new ArrayList<VirtualFile>(this.myFiles), (int)20);
            return "Files: (" + files + "); search in libraries: " + (this.myHasFilesOutOfProjectRoots != null ? this.myHasFilesOutOfProjectRoots : "unknown");
        }

        @Override
        @NotNull
        public Iterator<VirtualFile> iterator() {
            return this.myFiles.iterator();
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return this.mySearchOutsideRootModel;
        }
    }

    private static class FileScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final VirtualFile myVirtualFile;
        @Nullable
        private final String myDisplayName;
        private final Module myModule;
        private final boolean mySearchOutsideContent;

        private FileScope(@NotNull Project project, @Nullable VirtualFile virtualFile2, @Nullable String displayName) {
            super(project);
            this.myVirtualFile = virtualFile2;
            this.myDisplayName = displayName;
            FileIndexFacade facade = FileIndexFacade.getInstance(project);
            this.myModule = virtualFile2 == null || project.isDefault() ? null : facade.getModuleForFile(virtualFile2);
            this.mySearchOutsideContent = virtualFile2 != null && this.myModule == null && !facade.isInLibraryClasses(virtualFile2) && !facade.isInLibrarySource(virtualFile2);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            return Comparing.equal((Object)this.myVirtualFile, (Object)file);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return aModule == this.myModule;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }

        public String toString() {
            return "File :" + this.myVirtualFile;
        }

        @Override
        @NotNull
        public Iterator<VirtualFile> iterator() {
            return Collections.singletonList(this.myVirtualFile).iterator();
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return this.mySearchOutsideContent;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.myDisplayName != null ? this.myDisplayName : super.getDisplayName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            FileScope files = (FileScope)o;
            return this.mySearchOutsideContent == files.mySearchOutsideContent && Objects.equals(this.myVirtualFile, files.myVirtualFile) && Objects.equals(this.myDisplayName, files.myDisplayName) && Objects.equals(this.myModule, files.myModule);
        }

        @Override
        protected int calcHashCode() {
            return Objects.hash(this.myVirtualFile, this.myModule, this.mySearchOutsideContent, this.myDisplayName);
        }
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            return false;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            return this;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            return scope;
        }

        public String toString() {
            return "EMPTY";
        }
    }

    private static class FileTypeRestrictionScope
    extends DelegatingGlobalSearchScope {
        private final FileType[] myFileTypes;

        private FileTypeRestrictionScope(@NotNull GlobalSearchScope scope, @NotNull FileType[] fileTypes) {
            super(scope);
            this.myFileTypes = fileTypes;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (!super.contains(file)) {
                return false;
            }
            FileType fileType = file.getFileType();
            for (FileType otherFileType : this.myFileTypes) {
                if (!fileType.equals(otherFileType)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    ArrayList<FileType> intersection = new ArrayList<FileType>(Arrays.asList(restrict.myFileTypes));
                    intersection.retainAll(Arrays.asList(this.myFileTypes));
                    return new FileTypeRestrictionScope(this.myBaseScope, intersection.toArray(FileType.EMPTY_ARRAY));
                }
            }
            return super.intersectWith(scope);
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    return new FileTypeRestrictionScope(this.myBaseScope, (FileType[])ArrayUtil.mergeArrays((Object[])this.myFileTypes, (Object[])restrict.myFileTypes));
                }
            }
            return super.uniteWith(scope);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileTypeRestrictionScope)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileTypeRestrictionScope that = (FileTypeRestrictionScope)o;
            return Arrays.equals(this.myFileTypes, that.myFileTypes);
        }

        @Override
        public int calcHashCode() {
            int result2 = super.calcHashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.myFileTypes);
            return result2;
        }

        @Override
        public String toString() {
            return "(restricted by file types: " + Arrays.asList(this.myFileTypes) + " in " + this.myBaseScope + ")";
        }
    }

    private static class UnionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope[] myScopes;

        @NotNull
        static GlobalSearchScope create(@NotNull GlobalSearchScope[] scopes) {
            THashSet result2 = new THashSet(scopes.length);
            Project project = null;
            for (GlobalSearchScope scope : scopes) {
                if (scope == EMPTY_SCOPE) continue;
                Project scopeProject = scope.getProject();
                if (scopeProject != null) {
                    project = scopeProject;
                }
                if (scope instanceof UnionScope) {
                    ContainerUtil.addAll((Collection)result2, (Object[])((UnionScope)scope).myScopes);
                    continue;
                }
                result2.add(scope);
            }
            if (result2.isEmpty()) {
                return EMPTY_SCOPE;
            }
            if (result2.size() == 1) {
                return (GlobalSearchScope)result2.iterator().next();
            }
            return new UnionScope(project, result2.toArray(EMPTY_ARRAY));
        }

        private UnionScope(Project project, @NotNull GlobalSearchScope[] scopes) {
            super(project);
            this.myScopes = scopes;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return PsiBundle.message("psi.search.scope.union", this.myScopes[0].getDisplayName(), this.myScopes[1].getDisplayName());
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            return ContainerUtil.find((Object[])this.myScopes, scope -> scope.contains(file)) != null;
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return ContainerUtil.find((Object[])this.myScopes, GlobalSearchScope::isSearchOutsideRootModel) != null;
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            LinkedHashSet<UnloadedModuleDescription> result2 = new LinkedHashSet<UnloadedModuleDescription>();
            for (GlobalSearchScope scope : this.myScopes) {
                result2.addAll(scope.getUnloadedModulesBelongingToScope());
            }
            return result2;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            int[] result2 = new int[]{0};
            ContainerUtil.process((Object[])this.myScopes, scope -> {
                if (!scope.contains(file1) || !scope.contains(file2)) {
                    return true;
                }
                int cmp = scope.compare(file1, file2);
                if (result2[0] == 0) {
                    result2[0] = cmp;
                    return true;
                }
                if (cmp == 0) {
                    return true;
                }
                if (result2[0] > 0 == cmp > 0) {
                    return true;
                }
                result2[0] = 0;
                return false;
            });
            return result2[0];
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module) {
            return ContainerUtil.find((Object[])this.myScopes, scope -> scope.isSearchInModuleContent(module)) != null;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module, boolean testSources) {
            return ContainerUtil.find((Object[])this.myScopes, scope -> scope.isSearchInModuleContent(module, testSources)) != null;
        }

        @Override
        public boolean isSearchInLibraries() {
            return ContainerUtil.find((Object[])this.myScopes, GlobalSearchScope::isSearchInLibraries) != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnionScope)) {
                return false;
            }
            UnionScope that = (UnionScope)o;
            return new HashSet<GlobalSearchScope>(Arrays.asList(this.myScopes)).equals(new HashSet<GlobalSearchScope>(Arrays.asList(that.myScopes)));
        }

        @Override
        public int calcHashCode() {
            return Arrays.hashCode(this.myScopes);
        }

        @NonNls
        public String toString() {
            return "Union: (" + StringUtil.join(Arrays.asList(this.myScopes), (String)",") + ")";
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope instanceof UnionScope) {
                GlobalSearchScope[] newScopes = (GlobalSearchScope[])ArrayUtil.mergeArrays((Object[])this.myScopes, (Object[])((UnionScope)scope).myScopes);
                return UnionScope.create(newScopes);
            }
            return super.uniteWith(scope);
        }
    }

    private static class IntersectionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;
        private final String myDisplayName;

        private IntersectionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2, String displayName) {
            super(scope1.getProject() == null ? scope2.getProject() : scope1.getProject());
            this.myScope1 = scope1;
            this.myScope2 = scope2;
            this.myDisplayName = displayName;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            return this.containsScope(scope) ? this : new IntersectionScope(this, scope, null);
        }

        private boolean containsScope(@NotNull GlobalSearchScope scope) {
            if (this.myScope1.equals(scope) || this.myScope2.equals(scope) || this.equals(scope)) {
                return true;
            }
            if (this.myScope1 instanceof IntersectionScope && ((IntersectionScope)this.myScope1).containsScope(scope)) {
                return true;
            }
            return this.myScope2 instanceof IntersectionScope && ((IntersectionScope)this.myScope2).containsScope(scope);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDisplayName == null) {
                return PsiBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
            }
            return this.myDisplayName;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            return this.myScope1.contains(file) && this.myScope2.contains(file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            int res1 = this.myScope1.compare(file1, file2);
            int res2 = this.myScope2.compare(file1, file2);
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if (res1 > 0 == res2 > 0) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return this.myScope1.isSearchOutsideRootModel() && this.myScope2.isSearchOutsideRootModel();
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            return ContainerUtil.intersection(this.myScope1.getUnloadedModulesBelongingToScope(), this.myScope2.getUnloadedModulesBelongingToScope());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntersectionScope)) {
                return false;
            }
            IntersectionScope that = (IntersectionScope)o;
            return this.myScope1.equals(that.myScope1) && this.myScope2.equals(that.myScope2);
        }

        @Override
        public int calcHashCode() {
            return 31 * this.myScope1.hashCode() + this.myScope2.hashCode();
        }

        @NonNls
        public String toString() {
            return "Intersection: (" + this.myScope1 + ", " + this.myScope2 + ")";
        }
    }

    private static class NotScope
    extends DelegatingGlobalSearchScope {
        private NotScope(@NotNull GlobalSearchScope scope) {
            super(scope);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            return !this.myBaseScope.contains(file);
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return true;
        }

        @Override
        public String toString() {
            return "NOT: " + this.myBaseScope;
        }
    }
}

