/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalSearchScopes
extends GlobalSearchScopesCore {
    private GlobalSearchScopes() {
    }

    @NotNull
    public static GlobalSearchScope openFilesScope(@NotNull Project project) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance(project);
        VirtualFile[] files = fileEditorManager != null ? fileEditorManager.getOpenFiles() : VirtualFile.EMPTY_ARRAY;
        return GlobalSearchScope.filesScope(project, Arrays.asList(files), IdeBundle.message("scope.open.files", new Object[0]));
    }

    @NotNull
    public static GlobalSearchScope executionScope(@NotNull Project project, @Nullable RunProfile runProfile) {
        GlobalSearchScope scope;
        if (runProfile instanceof SearchScopeProvidingRunProfile && (scope = ((SearchScopeProvidingRunProfile)runProfile).getSearchScope()) != null) {
            return scope;
        }
        return GlobalSearchScope.allScope(project);
    }

    @Nullable
    public static GlobalSearchScope executionScope(@NotNull Collection<Module> modules) {
        if (modules.isEmpty()) {
            return null;
        }
        List scopes = ContainerUtil.map2List(modules, module -> GlobalSearchScope.moduleRuntimeScope(module, true));
        return GlobalSearchScope.union(scopes);
    }
}

