/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiElementProcessor<T extends PsiElement> {
    public boolean execute(@NotNull T var1);

    public static class FindFilteredElement<T extends PsiElement>
    extends FindElement<T> {
        private final PsiElementFilter myFilter;

        public FindFilteredElement(@NotNull PsiElementFilter filter) {
            this.myFilter = filter;
        }

        @Override
        public boolean execute(@NotNull T element) {
            return !this.myFilter.isAccepted((PsiElement)element) || super.execute(element);
        }
    }

    public static class FindElement<T extends PsiElement>
    implements PsiElementProcessor<T> {
        private volatile T myFoundElement;

        public boolean isFound() {
            return this.myFoundElement != null;
        }

        @Nullable
        public T getFoundElement() {
            return this.myFoundElement;
        }

        public boolean setFound(T element) {
            this.myFoundElement = element;
            return false;
        }

        @Override
        public boolean execute(@NotNull T element) {
            return this.setFound(element);
        }
    }

    public static class CollectElementsWithLimit<T extends PsiElement>
    extends CollectElements<T> {
        private final AtomicInteger myCount = new AtomicInteger(0);
        private volatile boolean myOverflow;
        private final int myLimit;

        public CollectElementsWithLimit(int limit) {
            this.myLimit = limit;
        }

        public CollectElementsWithLimit(int limit, @NotNull Collection<T> collection) {
            super(collection);
            this.myLimit = limit;
        }

        @Override
        public boolean execute(@NotNull T element) {
            if (this.myCount.get() == this.myLimit) {
                this.myOverflow = true;
                return false;
            }
            this.myCount.incrementAndGet();
            return super.execute(element);
        }

        public boolean isOverflow() {
            return this.myOverflow;
        }
    }

    public static class CollectFilteredElements<T extends PsiElement>
    extends CollectElements<T> {
        private final PsiElementFilter myFilter;

        public CollectFilteredElements(@NotNull PsiElementFilter filter, @NotNull Collection<T> collection) {
            super(collection);
            this.myFilter = filter;
        }

        public CollectFilteredElements(@NotNull PsiElementFilter filter) {
            this.myFilter = filter;
        }

        @Override
        public boolean execute(@NotNull T element) {
            return !this.myFilter.isAccepted((PsiElement)element) || super.execute(element);
        }
    }

    public static class CollectElements<T extends PsiElement>
    implements PsiElementProcessor<T> {
        private final Collection<T> myCollection;

        public CollectElements() {
            this(new ArrayList());
        }

        public CollectElements(@NotNull Collection<T> collection) {
            this.myCollection = Collections.synchronizedCollection(collection);
        }

        @NotNull
        public PsiElement[] toArray() {
            return PsiUtilCore.toPsiElementArray(this.myCollection);
        }

        @NotNull
        public Collection<T> getCollection() {
            return this.myCollection;
        }

        @NotNull
        public T[] toArray(T[] array) {
            return (PsiElement[])this.myCollection.toArray(array);
        }

        @Override
        public boolean execute(@NotNull T element) {
            this.myCollection.add(element);
            return true;
        }
    }
}

