/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.icons.AllIcons;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedScope {
    public static final NamedScope[] EMPTY_ARRAY = new NamedScope[0];
    private final String myName;
    private final Icon myIcon;
    private final PackageSet myValue;

    public NamedScope(@NotNull String name, @Nullable PackageSet value) {
        this(name, AllIcons.Ide.LocalScope, value);
    }

    public NamedScope(@NotNull String name, @NotNull Icon icon, @Nullable PackageSet value) {
        this.myIcon = icon;
        this.myName = name;
        this.myValue = value;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public PackageSet getValue() {
        return this.myValue;
    }

    @NotNull
    public NamedScope createCopy() {
        return new NamedScope(this.myName, this.myIcon, this.myValue == null ? null : this.myValue.createCopy());
    }

    public String toString() {
        return "Scope '" + this.myName + "'; set:" + (this.myValue == null ? null : this.myValue.getText());
    }

    public static class UnnamedScope
    extends NamedScope {
        public UnnamedScope(@NotNull PackageSet value) {
            super(value.getText(), value);
        }
    }
}

