/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.SimpleSmartExtensionPoint;
import com.intellij.openapi.extensions.SmartExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExtensibleQueryFactory<Result, Parameters>
extends QueryFactory<Result, Parameters> {
    private final SmartExtensionPoint<QueryExecutor<Result, Parameters>, QueryExecutor<Result, Parameters>> myPoint;

    protected ExtensibleQueryFactory() {
        this("com.intellij");
    }

    protected ExtensibleQueryFactory(final @NonNls String epNamespace) {
        this.myPoint = new SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>>(){

            @NotNull
            protected ExtensionPoint<QueryExecutor<Result, Parameters>> getExtensionPoint() {
                String epName = ExtensibleQueryFactory.this.getClass().getName();
                int pos = epName.lastIndexOf(46);
                if (pos >= 0) {
                    epName = epName.substring(pos + 1);
                }
                epName = epNamespace + "." + StringUtil.decapitalize((String)epName);
                return Extensions.getRootArea().getExtensionPoint(epName);
            }
        };
    }

    public void registerExecutor(final QueryExecutor<Result, Parameters> queryExecutor, Disposable parentDisposable) {
        this.registerExecutor(queryExecutor);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ExtensibleQueryFactory.this.unregisterExecutor(queryExecutor);
            }
        });
    }

    @Override
    public void registerExecutor(@NotNull QueryExecutor<Result, Parameters> queryExecutor) {
        this.myPoint.addExplicitExtension(queryExecutor);
    }

    @Override
    public void unregisterExecutor(@NotNull QueryExecutor<Result, Parameters> queryExecutor) {
        this.myPoint.removeExplicitExtension(queryExecutor);
    }

    @Override
    @NotNull
    protected List<QueryExecutor<Result, Parameters>> getExecutors() {
        return this.myPoint.getExtensions();
    }
}

