/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.DumbAwareSearchParameters;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchRequestQuery;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.search.searches.ReferenceDescriptor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.MergeQuery;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.referencesSearch");
    private static final ReferencesSearch INSTANCE = new ReferencesSearch();

    private ReferencesSearch() {
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element) {
        return ReferencesSearch.search(element, GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(element)), false);
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element, @NotNull SearchScope searchScope) {
        return ReferencesSearch.search(element, searchScope, false);
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope) {
        return ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope));
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull SearchParameters parameters) {
        Query result2 = INSTANCE.createQuery(parameters);
        if (parameters.isSharedOptimizer) {
            return ReferencesSearch.uniqueResults(result2);
        }
        SearchRequestCollector requests = parameters.getOptimizer();
        PsiElement element = parameters.getElementToSearch();
        return ReferencesSearch.uniqueResults(new MergeQuery<PsiReference>(result2, new SearchRequestQuery(PsiUtilCore.getProjectInReadAction(element), requests)));
    }

    @NotNull
    private static Query<PsiReference> uniqueResults(@NotNull Query<? extends PsiReference> composite) {
        return new UniqueResultsQuery<PsiReference, ReferenceDescriptor>(composite, ContainerUtil.canonicalStrategy(), ReferenceDescriptor.MAPPER);
    }

    public static void searchOptimized(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope, @NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor) {
        ReferencesSearch.searchOptimized(element, searchScope, ignoreAccessScope, collector, false, (PairProcessor<PsiReference, SearchRequestCollector>)((PairProcessor)(psiReference, collector1) -> processor.process(psiReference)));
    }

    public static void searchOptimized(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope, @NotNull SearchRequestCollector collector, boolean inReadAction, @NotNull PairProcessor<PsiReference, SearchRequestCollector> processor) {
        SearchRequestCollector nested = new SearchRequestCollector(collector.getSearchSession());
        Query<PsiReference> query = ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope, nested));
        collector.searchQuery(new QuerySearchRequest(query, nested, inReadAction, processor));
    }

    public static class SearchParameters
    implements DumbAwareSearchParameters {
        private final PsiElement myElementToSearch;
        private final SearchScope myScope;
        private volatile SearchScope myEffectiveScope;
        private final boolean myIgnoreAccessScope;
        private final SearchRequestCollector myOptimizer;
        private final Project myProject;
        private final boolean isSharedOptimizer;

        public SearchParameters(@NotNull PsiElement elementToSearch, @NotNull SearchScope scope, boolean ignoreAccessScope, @Nullable SearchRequestCollector optimizer) {
            this.myElementToSearch = elementToSearch;
            this.myScope = scope;
            this.myIgnoreAccessScope = ignoreAccessScope;
            this.isSharedOptimizer = optimizer != null;
            this.myOptimizer = optimizer == null ? new SearchRequestCollector(new SearchSession()) : optimizer;
            this.myProject = PsiUtilCore.getProjectInReadAction(elementToSearch);
        }

        public SearchParameters(@NotNull PsiElement elementToSearch, @NotNull SearchScope scope, boolean ignoreAccessScope) {
            this(elementToSearch, scope, ignoreAccessScope, null);
        }

        @Override
        public boolean isQueryValid() {
            return this.myElementToSearch.isValid();
        }

        @Override
        @NotNull
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public PsiElement getElementToSearch() {
            return this.myElementToSearch;
        }

        public SearchScope getScopeDeterminedByUser() {
            return this.myScope;
        }

        @Deprecated
        @NotNull
        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isIgnoreAccessScope() {
            return this.myIgnoreAccessScope;
        }

        @NotNull
        public SearchRequestCollector getOptimizer() {
            return this.myOptimizer;
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            if (this.myIgnoreAccessScope) {
                return this.myScope;
            }
            SearchScope scope = this.myEffectiveScope;
            if (scope == null) {
                if (!this.myElementToSearch.isValid()) {
                    return GlobalSearchScope.EMPTY_SCOPE;
                }
                SearchScope useScope = PsiSearchHelper.getInstance(this.myElementToSearch.getProject()).getUseScope(this.myElementToSearch);
                this.myEffectiveScope = scope = this.myScope.intersectWith(useScope);
            }
            return scope;
        }
    }
}

