/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.MaterialStubList;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubBase<T extends PsiElement>
extends ObjectStubBase<StubElement>
implements StubElement<T> {
    StubList myStubList;
    private volatile T myPsi;
    private static final AtomicFieldUpdater<StubBase, PsiElement> ourPsiUpdater = AtomicFieldUpdater.forFieldOfType(StubBase.class, PsiElement.class);

    protected StubBase(StubElement parent, IStubElementType elementType) {
        super(parent);
        this.myStubList = parent == null ? new MaterialStubList(10) : ((StubBase)parent).myStubList;
        this.myStubList.addStub(this, (StubBase)parent, elementType);
    }

    @Override
    public StubElement getParentStub() {
        return (StubElement)this.myParent;
    }

    @Override
    @NotNull
    public List<StubElement> getChildrenStubs() {
        return this.myStubList.getChildrenStubs(this.id);
    }

    @Override
    @Nullable
    public <P extends PsiElement, S extends StubElement<P>> S findChildStubByType(@NotNull IStubElementType<S, P> elementType) {
        return this.myStubList.findChildStubByType(this.id, elementType);
    }

    public void setPsi(@NotNull T psi) {
        assert (this.myPsi == null || this.myPsi == psi);
        this.myPsi = psi;
    }

    @Nullable
    final T getCachedPsi() {
        return this.myPsi;
    }

    @Override
    public T getPsi() {
        Object psi = this.myPsi;
        if (psi != null) {
            return psi;
        }
        psi = this.getStubType().createPsi(this);
        return (T)(ourPsiUpdater.compareAndSet((Object)this, null, psi) ? psi : (PsiElement)ObjectUtils.assertNotNull(this.myPsi));
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull IElementType elementType, E[] array) {
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count = StubBase.countChildren(elementType, childrenStubs);
        array = (PsiElement[])ArrayUtil.ensureExactSize((int)count, (Object[])array);
        if (count == 0) {
            return array;
        }
        StubBase.fillFilteredChildren((IElementType)elementType, array, childrenStubs);
        return array;
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull TokenSet filter, E[] array) {
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count = StubBase.countChildren(filter, childrenStubs);
        array = (PsiElement[])ArrayUtil.ensureExactSize((int)count, (Object[])array);
        if (count == 0) {
            return array;
        }
        StubBase.fillFilteredChildren((TokenSet)filter, array, childrenStubs);
        return array;
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull IElementType elementType, @NotNull ArrayFactory<E> f) {
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count = StubBase.countChildren(elementType, childrenStubs);
        PsiElement[] result2 = (PsiElement[])f.create(count);
        if (count > 0) {
            StubBase.fillFilteredChildren((IElementType)elementType, (PsiElement[])result2, childrenStubs);
        }
        return result2;
    }

    private static int countChildren(IElementType elementType, List<? extends StubElement> childrenStubs) {
        int count = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != elementType) continue;
            ++count;
        }
        return count;
    }

    private static int countChildren(TokenSet types, List<? extends StubElement> childrenStubs) {
        int count = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (!types.contains(childStub.getStubType())) continue;
            ++count;
        }
        return count;
    }

    private static <E extends PsiElement> void fillFilteredChildren(IElementType type, E[] result2, List<? extends StubElement> childrenStubs) {
        int count = 0;
        for (StubElement stubElement : childrenStubs) {
            if (stubElement.getStubType() != type) continue;
            result2[count++] = stubElement.getPsi();
        }
        assert (count == result2.length);
    }

    private static <E extends PsiElement> void fillFilteredChildren(TokenSet set, E[] result2, List<? extends StubElement> childrenStubs) {
        int count = 0;
        for (StubElement stubElement : childrenStubs) {
            if (!set.contains(stubElement.getStubType())) continue;
            result2[count++] = stubElement.getPsi();
        }
        assert (count == result2.length);
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull TokenSet filter, @NotNull ArrayFactory<E> f) {
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count = StubBase.countChildren(filter, childrenStubs);
        PsiElement[] array = (PsiElement[])f.create(count);
        if (count == 0) {
            return array;
        }
        StubBase.fillFilteredChildren((TokenSet)filter, (PsiElement[])array, childrenStubs);
        return array;
    }

    @Override
    @Nullable
    public <E extends PsiElement> E getParentStubOfType(@NotNull Class<E> parentClass) {
        for (StubElement parent = (StubElement)this.myParent; parent != null; parent = parent.getParentStub()) {
            Object psi = parent.getPsi();
            if (!parentClass.isInstance(psi)) continue;
            return (E)psi;
        }
        return null;
    }

    @Override
    public IStubElementType getStubType() {
        return this.myStubList.getStubType(this.id);
    }

    public Project getProject() {
        return this.getPsi().getProject();
    }

    public String printTree() {
        StringBuilder builder = new StringBuilder();
        this.printTree(builder, 0);
        return builder.toString();
    }

    private void printTree(StringBuilder builder, int nestingLevel) {
        for (int i = 0; i < nestingLevel; ++i) {
            builder.append("  ");
        }
        builder.append(this).append('\n');
        for (StubElement child : this.getChildrenStubs()) {
            ((StubBase)child).printTree(builder, nestingLevel + 1);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public int compareByOrderWith(ObjectStubBase<?> another) {
        return Integer.compare(this.getStubId(), another.getStubId());
    }
}

