/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateLanguageUtil {
    private TemplateLanguageUtil() {
    }

    @Nullable
    public static PsiFile getTemplateFile(PsiFile file) {
        FileViewProvider viewProvider = file.getViewProvider();
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            return viewProvider.getPsi(((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage());
        }
        return null;
    }

    public static PsiFile getBaseFile(@NotNull PsiFile file) {
        FileViewProvider viewProvider = file.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    public static boolean isInsideTemplateFile(@NotNull PsiElement element) {
        return element.getContainingFile().getViewProvider() instanceof TemplateLanguageFileViewProvider;
    }
}

