/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ProfilingInfo;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedValueProfiler {
    private static final CachedValueProfiler ourInstance = new CachedValueProfiler();
    private volatile ConcurrentMultiMap<StackTraceElement, ProfilingInfo> myStorage = null;
    private final Object myLock = new Object();
    private final ConcurrentMap<CachedValueProvider.Result, ProfilingInfo> myTemporaryResults = ContainerUtil.newConcurrentMap();

    public static boolean canProfile() {
        return ApplicationManager.getApplication().isInternal();
    }

    public boolean isEnabled() {
        return this.myStorage != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean value) {
        Object object = this.myLock;
        synchronized (object) {
            if (value) {
                ConcurrentMultiMap<StackTraceElement, ProfilingInfo> storage = this.myStorage;
                if (storage == null) {
                    this.myStorage = new ConcurrentMultiMap();
                }
            } else {
                this.myStorage = null;
            }
        }
    }

    @NotNull
    public static CachedValueProfiler getInstance() {
        return ourInstance;
    }

    public void createInfo(@NotNull CachedValueProvider.Result<?> result2) {
        ConcurrentMultiMap<StackTraceElement, ProfilingInfo> storage = this.myStorage;
        if (storage == null) {
            return;
        }
        StackTraceElement origin = CachedValueProfiler.findOrigin();
        if (origin == null) {
            return;
        }
        ProfilingInfo info = new ProfilingInfo(origin);
        storage.putValue((Object)origin, (Object)info);
        this.myTemporaryResults.put(result2, info);
    }

    @Nullable
    public <T> ProfilingInfo getTemporaryInfo(@NotNull CachedValueProvider.Result<T> result2) {
        return (ProfilingInfo)this.myTemporaryResults.remove(result2);
    }

    public MultiMap<StackTraceElement, ProfilingInfo> getStorageSnapshot() {
        return this.myStorage.copy();
    }

    @Nullable
    private static StackTraceElement findOrigin() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        return CachedValueProfiler.findFirstStackTraceElementExcluding(stackTrace, CachedValueProfiler.class.getName(), CachedValueProvider.class.getName());
    }

    @Nullable
    private static StackTraceElement findFirstStackTraceElementExcluding(@NotNull StackTraceElement[] stackTraceElements, String ... excludedClasses) {
        for (StackTraceElement element : stackTraceElements) {
            if (CachedValueProfiler.matches(element, excludedClasses)) continue;
            return element;
        }
        return null;
    }

    private static boolean matches(@NotNull StackTraceElement element, @NotNull String[] excludedClasses) {
        for (String aClass : excludedClasses) {
            if (!element.getClassName().startsWith(aClass)) continue;
            return true;
        }
        return false;
    }
}

