/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class ProfilingInfo {
    private final long myCreatedTimeStamp;
    private volatile long myDisposedTimeStamp = -1L;
    private final AtomicLong myUseCount = new AtomicLong();
    @NotNull
    private final StackTraceElement myOrigin;

    public ProfilingInfo(@NotNull StackTraceElement origin) {
        this.myCreatedTimeStamp = ProfilingInfo.currentTime();
        this.myOrigin = origin;
    }

    public synchronized void valueDisposed() {
        if (this.myDisposedTimeStamp != 0L) {
            this.myDisposedTimeStamp = ProfilingInfo.currentTime();
        }
    }

    public void valueUsed() {
        this.myUseCount.incrementAndGet();
    }

    public long getCreatedTimeStamp() {
        return this.myCreatedTimeStamp;
    }

    public long getDisposedTimeStamp() {
        return this.myDisposedTimeStamp;
    }

    public long getUseCount() {
        return this.myUseCount.get();
    }

    public long getLifetime() {
        long disposedTime = this.myDisposedTimeStamp;
        if (disposedTime == -1L) {
            disposedTime = ProfilingInfo.currentTime();
        }
        return disposedTime - this.myCreatedTimeStamp;
    }

    @NotNull
    public StackTraceElement getOrigin() {
        return this.myOrigin;
    }

    private static long currentTime() {
        return System.currentTimeMillis();
    }
}

