/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCacheKey<T, H extends PsiElement>
extends Key<SoftReference<Pair<Long, T>>> {
    private final Function<? super H, ? extends T> myFunction;
    @NotNull
    private final Key<?> myModifyCause;

    private PsiCacheKey(@NonNls @NotNull String name, @NotNull Function<? super H, ? extends T> function, @NotNull Key<?> modifyCause) {
        super(name);
        this.myFunction = function;
        this.myModifyCause = modifyCause;
    }

    public final T getValue(@NotNull H h) {
        Object result2 = this.getCachedValueOrNull(h);
        if (result2 != null) {
            return result2;
        }
        result2 = this.myFunction.fun(h);
        long count = this.getModificationCount((PsiElement)h);
        h.putUserData((Key)this, (Object)new SoftReference((Object)new Pair((Object)count, result2)));
        return result2;
    }

    @Nullable
    public final T getCachedValueOrNull(@NotNull H h) {
        SoftReference ref = (SoftReference)h.getUserData((Key)this);
        Pair data = (Pair)SoftReference.dereference((Reference)ref);
        if (data == null || ((Long)data.getFirst()).longValue() != this.getModificationCount((PsiElement)h)) {
            return null;
        }
        return (T)data.getSecond();
    }

    private long getModificationCount(@NotNull PsiElement element) {
        PsiModificationTracker tracker;
        PsiFile file = element.getContainingFile();
        long fileStamp = file == null || file.isPhysical() ? 0L : file.getModificationStamp();
        PsiModificationTracker psiModificationTracker = tracker = file == null ? element.getManager().getModificationTracker() : file.getManager().getModificationTracker();
        if (this.myModifyCause.equals((Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT)) {
            return fileStamp + tracker.getJavaStructureModificationCount();
        }
        if (this.myModifyCause.equals((Object)PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT)) {
            return fileStamp + tracker.getOutOfCodeBlockModificationCount();
        }
        if (this.myModifyCause.equals((Object)PsiModificationTracker.MODIFICATION_COUNT)) {
            return fileStamp + tracker.getModificationCount();
        }
        throw new AssertionError((Object)("No modification tracker found for key " + this.myModifyCause));
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name, @NotNull Function<? super H, ? extends T> function, @NotNull Key<?> modifyCause) {
        return new PsiCacheKey<T, H>(name, function, modifyCause);
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name, @NotNull Function<? super H, ? extends T> function) {
        return PsiCacheKey.create(name, function, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
    }
}

